/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.snapshot;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.FSMCaller;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.closure.LoadSnapshotClosure;
import com.alipay.sofa.jraft.closure.SaveSnapshotClosure;
import com.alipay.sofa.jraft.core.NodeImpl;
import com.alipay.sofa.jraft.entity.EnumOutter;
import com.alipay.sofa.jraft.entity.RaftOutter;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.error.RaftException;
import com.alipay.sofa.jraft.option.SnapshotCopierOptions;
import com.alipay.sofa.jraft.option.SnapshotExecutorOptions;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcRequests;
import com.alipay.sofa.jraft.storage.LogManager;
import com.alipay.sofa.jraft.storage.SnapshotExecutor;
import com.alipay.sofa.jraft.storage.SnapshotStorage;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotCopier;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import com.alipay.sofa.jraft.storage.snapshot.local.LocalSnapshotStorage;
import com.alipay.sofa.jraft.util.CountDownEvent;
import com.alipay.sofa.jraft.util.Describer;
import com.alipay.sofa.jraft.util.OnlyForTest;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.RpcFactoryHelper;
import com.alipay.sofa.jraft.util.ThreadPoolsFactory;
import com.alipay.sofa.jraft.util.Utils;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotExecutorImpl
implements SnapshotExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotExecutorImpl.class);
    private final Lock lock = new ReentrantLock();
    private long lastSnapshotTerm;
    private long lastSnapshotIndex;
    private long term;
    private volatile boolean savingSnapshot;
    private volatile boolean loadingSnapshot;
    private volatile boolean stopped;
    private SnapshotStorage snapshotStorage;
    private SnapshotCopier curCopier;
    private FSMCaller fsmCaller;
    private NodeImpl node;
    private LogManager logManager;
    private final AtomicReference<DownloadingSnapshot> downloadingSnapshot = new AtomicReference<Object>(null);
    private RaftOutter.SnapshotMeta loadingSnapshotMeta;
    private final CountDownEvent runningJobs = new CountDownEvent();

    @OnlyForTest
    public long getLastSnapshotTerm() {
        return this.lastSnapshotTerm;
    }

    @OnlyForTest
    public long getLastSnapshotIndex() {
        return this.lastSnapshotIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(SnapshotExecutorOptions opts) {
        SnapshotReader reader;
        LocalSnapshotStorage tmp;
        if (StringUtils.isBlank((String)opts.getUri())) {
            LOG.error("Snapshot uri is empty.");
            return false;
        }
        this.logManager = opts.getLogManager();
        this.fsmCaller = opts.getFsmCaller();
        this.node = opts.getNode();
        this.term = opts.getInitTerm();
        this.snapshotStorage = this.node.getServiceFactory().createSnapshotStorage(opts.getUri(), this.node.getRaftOptions());
        if (opts.isFilterBeforeCopyRemote()) {
            this.snapshotStorage.setFilterBeforeCopyRemote();
        }
        if (opts.getSnapshotThrottle() != null) {
            this.snapshotStorage.setSnapshotThrottle(opts.getSnapshotThrottle());
        }
        if (!this.snapshotStorage.init(null)) {
            LOG.error("Fail to init snapshot storage.");
            return false;
        }
        if (this.snapshotStorage instanceof LocalSnapshotStorage && !(tmp = (LocalSnapshotStorage)this.snapshotStorage).hasServerAddr()) {
            tmp.setServerAddr(opts.getAddr());
        }
        if ((reader = this.snapshotStorage.open()) == null) {
            return true;
        }
        this.loadingSnapshotMeta = reader.load();
        if (this.loadingSnapshotMeta == null) {
            LOG.error("Fail to load meta from {}.", (Object)opts.getUri());
            Utils.closeQuietly(reader);
            return false;
        }
        LOG.info("Loading snapshot, meta={}.", (Object)this.loadingSnapshotMeta);
        this.loadingSnapshot = true;
        this.runningJobs.incrementAndGet();
        FirstSnapshotLoadDone done = new FirstSnapshotLoadDone(reader);
        Requires.requireTrue(this.fsmCaller.onSnapshotLoad(done));
        try {
            done.waitForRun();
        }
        catch (InterruptedException e) {
            LOG.warn("Wait for FirstSnapshotLoadDone run is interrupted.");
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            Utils.closeQuietly(reader);
        }
        if (!done.status.isOk()) {
            LOG.error("Fail to load snapshot from {}, FirstSnapshotLoadDone status is {}.", (Object)opts.getUri(), (Object)done.status);
            return false;
        }
        return true;
    }

    @Override
    public void shutdown() {
        long savedTerm;
        this.lock.lock();
        try {
            savedTerm = this.term;
            this.stopped = true;
        }
        finally {
            this.lock.unlock();
        }
        this.interruptDownloadingSnapshots(savedTerm);
    }

    @Override
    public NodeImpl getNode() {
        return this.node;
    }

    @Override
    public void doSnapshot(Closure done) {
        this.doSnapshot(done, false);
    }

    @Override
    public void doSnapshotSync(Closure done) {
        this.doSnapshot(done, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSnapshot(Closure done, boolean sync) {
        boolean doUnlock = true;
        this.lock.lock();
        try {
            if (this.stopped) {
                ThreadPoolsFactory.runClosureInThread(this.getNode().getGroupId(), done, new Status(RaftError.EPERM, "Is stopped.", new Object[0]));
                return;
            }
            if (sync && !this.fsmCaller.isRunningOnFSMThread()) {
                ThreadPoolsFactory.runClosureInThread(this.getNode().getGroupId(), done, new Status(RaftError.EACCES, "trigger snapshot synchronously out of StateMachine's callback methods", new Object[0]));
                throw new IllegalStateException("You can't trigger snapshot synchronously out of StateMachine's callback methods.");
            }
            if (this.downloadingSnapshot.get() != null) {
                ThreadPoolsFactory.runClosureInThread(this.getNode().getGroupId(), done, new Status(RaftError.EBUSY, "Is loading another snapshot.", new Object[0]));
                return;
            }
            if (this.savingSnapshot) {
                ThreadPoolsFactory.runClosureInThread(this.getNode().getGroupId(), done, new Status(RaftError.EBUSY, "Is saving another snapshot.", new Object[0]));
                return;
            }
            if (this.fsmCaller.getLastAppliedIndex() == this.lastSnapshotIndex) {
                doUnlock = false;
                this.lock.unlock();
                this.logManager.clearBufferedLogs();
                ThreadPoolsFactory.runClosureInThread(this.getNode().getGroupId(), done);
                return;
            }
            long distance = this.fsmCaller.getLastAppliedIndex() - this.lastSnapshotIndex;
            if (distance < (long)this.node.getOptions().getSnapshotLogIndexMargin()) {
                if (this.node != null) {
                    LOG.debug("Node {} snapshotLogIndexMargin={}, distance={}, so ignore this time of snapshot by snapshotLogIndexMargin setting.", new Object[]{this.node.getNodeId(), distance, this.node.getOptions().getSnapshotLogIndexMargin()});
                }
                doUnlock = false;
                this.lock.unlock();
                ThreadPoolsFactory.runClosureInThread(this.getNode().getGroupId(), done, new Status(RaftError.ECANCELED, "The snapshot index distance since last snapshot is less than NodeOptions#snapshotLogIndexMargin, canceled this task.", new Object[0]));
                return;
            }
            SnapshotWriter writer = this.snapshotStorage.create();
            if (writer == null) {
                ThreadPoolsFactory.runClosureInThread(this.getNode().getGroupId(), done, new Status(RaftError.EIO, "Fail to create writer.", new Object[0]));
                this.reportError(RaftError.EIO.getNumber(), "Fail to create snapshot writer.", new Object[0]);
                return;
            }
            this.savingSnapshot = true;
            SaveSnapshotDone saveSnapshotDone = new SaveSnapshotDone(writer, done, null);
            if (sync) {
                this.fsmCaller.onSnapshotSaveSync(saveSnapshotDone);
            } else if (!this.fsmCaller.onSnapshotSave(saveSnapshotDone)) {
                ThreadPoolsFactory.runClosureInThread(this.getNode().getGroupId(), done, new Status(RaftError.EHOSTDOWN, "The raft node is down.", new Object[0]));
                return;
            }
            this.runningJobs.incrementAndGet();
        }
        finally {
            if (doUnlock) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int onSnapshotSaveDone(Status st, RaftOutter.SnapshotMeta meta, SnapshotWriter writer) {
        int ret;
        this.lock.lock();
        try {
            ret = st.getCode();
            if (st.isOk() && meta.getLastIncludedIndex() <= this.lastSnapshotIndex) {
                ret = RaftError.ESTALE.getNumber();
                if (this.node != null) {
                    LOG.warn("Node {} discards an stale snapshot lastIncludedIndex={}, lastSnapshotIndex={}.", new Object[]{this.node.getNodeId(), meta.getLastIncludedIndex(), this.lastSnapshotIndex});
                }
                writer.setError(RaftError.ESTALE, "Installing snapshot is older than local snapshot", new Object[0]);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (ret == 0) {
            if (!writer.saveMeta(meta)) {
                LOG.warn("Fail to save snapshot {}.", (Object)writer.getPath());
                ret = RaftError.EIO.getNumber();
            }
        } else if (writer.isOk()) {
            writer.setError(ret, "Fail to do snapshot.", new Object[0]);
        }
        try {
            writer.close();
        }
        catch (IOException e) {
            LOG.error("Fail to close writer", (Throwable)e);
            ret = RaftError.EIO.getNumber();
        }
        boolean doUnlock = true;
        this.lock.lock();
        try {
            if (ret == 0) {
                this.lastSnapshotIndex = meta.getLastIncludedIndex();
                this.lastSnapshotTerm = meta.getLastIncludedTerm();
                doUnlock = false;
                this.lock.unlock();
                this.logManager.setSnapshot(meta);
                doUnlock = true;
                this.lock.lock();
            }
            if (ret == RaftError.EIO.getNumber()) {
                this.reportError(RaftError.EIO.getNumber(), "Fail to save snapshot.", new Object[0]);
            }
            this.savingSnapshot = false;
            this.runningJobs.countDown();
            int n = ret;
            return n;
        }
        finally {
            if (doUnlock) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSnapshotLoadDone(Status st) {
        DownloadingSnapshot m;
        boolean doUnlock = true;
        this.lock.lock();
        try {
            Requires.requireTrue(this.loadingSnapshot, "Not loading snapshot");
            m = this.downloadingSnapshot.get();
            if (st.isOk()) {
                this.lastSnapshotIndex = this.loadingSnapshotMeta.getLastIncludedIndex();
                this.lastSnapshotTerm = this.loadingSnapshotMeta.getLastIncludedTerm();
                doUnlock = false;
                this.lock.unlock();
                this.logManager.setSnapshot(this.loadingSnapshotMeta);
                doUnlock = true;
                this.lock.lock();
            }
            StringBuilder sb = new StringBuilder();
            if (this.node != null) {
                sb.append("Node ").append(this.node.getNodeId()).append(" ");
            }
            sb.append("onSnapshotLoadDone, ").append(this.loadingSnapshotMeta);
            LOG.info(sb.toString());
            doUnlock = false;
            this.lock.unlock();
            if (this.node != null) {
                this.node.updateConfigurationAfterInstallingSnapshot();
            }
            doUnlock = true;
            this.lock.lock();
            this.loadingSnapshot = false;
            this.downloadingSnapshot.set(null);
        }
        finally {
            if (doUnlock) {
                this.lock.unlock();
            }
        }
        if (m != null) {
            if (!st.isOk()) {
                m.done.run(st);
            } else {
                m.responseBuilder.setSuccess(true);
                m.done.sendResponse((Message)m.responseBuilder.build());
            }
        }
        this.runningJobs.countDown();
    }

    @Override
    public void installSnapshot(RpcRequests.InstallSnapshotRequest request, RpcRequests.InstallSnapshotResponse.Builder response, RpcRequestClosure done) {
        RaftOutter.SnapshotMeta meta = request.getMeta();
        DownloadingSnapshot ds = new DownloadingSnapshot(request, response, done);
        if (!this.registerDownloadingSnapshot(ds)) {
            LOG.warn("Fail to register downloading snapshot.");
            return;
        }
        Requires.requireNonNull(this.curCopier, "curCopier");
        try {
            this.curCopier.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Install snapshot copy job was canceled.");
            return;
        }
        this.loadDownloadingSnapshot(ds, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadDownloadingSnapshot(DownloadingSnapshot ds, RaftOutter.SnapshotMeta meta) {
        SnapshotReader reader;
        this.lock.lock();
        try {
            if (ds != this.downloadingSnapshot.get()) {
                return;
            }
            Requires.requireNonNull(this.curCopier, "curCopier");
            reader = this.curCopier.getReader();
            if (!this.curCopier.isOk()) {
                if (this.curCopier.getCode() == RaftError.EIO.getNumber()) {
                    this.reportError(this.curCopier.getCode(), this.curCopier.getErrorMsg(), new Object[0]);
                }
                Utils.closeQuietly(reader);
                ds.done.run(this.curCopier);
                Utils.closeQuietly(this.curCopier);
                this.curCopier = null;
                this.downloadingSnapshot.set(null);
                this.runningJobs.countDown();
                return;
            }
            Utils.closeQuietly(this.curCopier);
            this.curCopier = null;
            if (reader == null || !reader.isOk()) {
                Utils.closeQuietly(reader);
                this.downloadingSnapshot.set(null);
                ds.done.sendResponse(RpcFactoryHelper.responseFactory().newResponse((Message)RpcRequests.InstallSnapshotResponse.getDefaultInstance(), RaftError.EINTERNAL, "Fail to copy snapshot from %s", ds.request.getUri()));
                this.runningJobs.countDown();
                return;
            }
            this.loadingSnapshot = true;
            this.loadingSnapshotMeta = meta;
        }
        finally {
            this.lock.unlock();
        }
        InstallSnapshotDone installSnapshotDone = new InstallSnapshotDone(reader);
        if (!this.fsmCaller.onSnapshotLoad(installSnapshotDone)) {
            LOG.warn("Fail to call fsm onSnapshotLoad.");
            installSnapshotDone.run(new Status(RaftError.EHOSTDOWN, "This raft node is down", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean registerDownloadingSnapshot(DownloadingSnapshot ds) {
        boolean result;
        DownloadingSnapshot saved;
        block21: {
            saved = null;
            result = true;
            this.lock.lock();
            try {
                if (this.stopped) {
                    LOG.warn("Register DownloadingSnapshot failed: node is stopped.");
                    ds.done.sendResponse(RpcFactoryHelper.responseFactory().newResponse((Message)RpcRequests.InstallSnapshotResponse.getDefaultInstance(), RaftError.EHOSTDOWN, "Node is stopped.", new Object[0]));
                    boolean bl = false;
                    return bl;
                }
                if (this.savingSnapshot) {
                    LOG.warn("Register DownloadingSnapshot failed: is saving snapshot.");
                    ds.done.sendResponse(RpcFactoryHelper.responseFactory().newResponse((Message)RpcRequests.InstallSnapshotResponse.getDefaultInstance(), RaftError.EBUSY, "Node is saving snapshot.", new Object[0]));
                    boolean bl = false;
                    return bl;
                }
                ds.responseBuilder.setTerm(this.term);
                if (ds.request.getTerm() != this.term) {
                    LOG.warn("Register DownloadingSnapshot failed: term mismatch, expect {} but {}.", (Object)this.term, (Object)ds.request.getTerm());
                    ds.responseBuilder.setSuccess(false);
                    ds.done.sendResponse((Message)ds.responseBuilder.build());
                    boolean bl = false;
                    return bl;
                }
                if (ds.request.getMeta().getLastIncludedIndex() <= this.lastSnapshotIndex) {
                    LOG.warn("Register DownloadingSnapshot failed: snapshot is not newer, request lastIncludedIndex={}, lastSnapshotIndex={}.", (Object)ds.request.getMeta().getLastIncludedIndex(), (Object)this.lastSnapshotIndex);
                    ds.responseBuilder.setSuccess(true);
                    ds.done.sendResponse((Message)ds.responseBuilder.build());
                    boolean bl = false;
                    return bl;
                }
                DownloadingSnapshot m = this.downloadingSnapshot.get();
                if (m == null) {
                    this.downloadingSnapshot.set(ds);
                    Requires.requireTrue(this.curCopier == null, "Current copier is not null");
                    this.curCopier = this.snapshotStorage.startToCopyFrom(ds.request.getUri(), this.newCopierOpts());
                    if (this.curCopier == null) {
                        this.downloadingSnapshot.set(null);
                        LOG.warn("Register DownloadingSnapshot failed: fail to copy file from {}.", (Object)ds.request.getUri());
                        ds.done.sendResponse(RpcFactoryHelper.responseFactory().newResponse((Message)RpcRequests.InstallSnapshotResponse.getDefaultInstance(), RaftError.EINVAL, "Fail to copy from: %s", ds.request.getUri()));
                        boolean bl = false;
                        return bl;
                    }
                    this.runningJobs.incrementAndGet();
                    boolean bl = true;
                    return bl;
                }
                if (m.request.getMeta().getLastIncludedIndex() == ds.request.getMeta().getLastIncludedIndex()) {
                    saved = m;
                    this.downloadingSnapshot.set(ds);
                    result = true;
                    break block21;
                }
                if (m.request.getMeta().getLastIncludedIndex() > ds.request.getMeta().getLastIncludedIndex()) {
                    LOG.warn("Register DownloadingSnapshot failed: is installing a newer one, lastIncludeIndex={}.", (Object)m.request.getMeta().getLastIncludedIndex());
                    ds.done.sendResponse(RpcFactoryHelper.responseFactory().newResponse((Message)RpcRequests.InstallSnapshotResponse.getDefaultInstance(), RaftError.EINVAL, "A newer snapshot is under installing", new Object[0]));
                    boolean bl = false;
                    return bl;
                }
                if (this.loadingSnapshot) {
                    LOG.warn("Register DownloadingSnapshot failed: is loading an older snapshot, lastIncludeIndex={}.", (Object)m.request.getMeta().getLastIncludedIndex());
                    ds.done.sendResponse(RpcFactoryHelper.responseFactory().newResponse((Message)RpcRequests.InstallSnapshotResponse.getDefaultInstance(), RaftError.EBUSY, "A former snapshot is under loading", new Object[0]));
                    boolean bl = false;
                    return bl;
                }
                Requires.requireNonNull(this.curCopier, "curCopier");
                this.curCopier.cancel();
                LOG.warn("Register DownloadingSnapshot failed: an older snapshot is under installing, cancel downloading, lastIncludeIndex={}.", (Object)m.request.getMeta().getLastIncludedIndex());
                ds.done.sendResponse(RpcFactoryHelper.responseFactory().newResponse((Message)RpcRequests.InstallSnapshotResponse.getDefaultInstance(), RaftError.EBUSY, "A former snapshot is under installing, trying to cancel", new Object[0]));
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        if (saved != null) {
            LOG.warn("Register DownloadingSnapshot failed: interrupted by retry installing request.");
            saved.done.sendResponse(RpcFactoryHelper.responseFactory().newResponse((Message)RpcRequests.InstallSnapshotResponse.getDefaultInstance(), RaftError.EINTR, "Interrupted by the retry InstallSnapshotRequest", new Object[0]));
        }
        return result;
    }

    private SnapshotCopierOptions newCopierOpts() {
        SnapshotCopierOptions copierOpts = new SnapshotCopierOptions();
        copierOpts.setNodeOptions(this.node.getOptions());
        copierOpts.setRaftClientService(this.node.getRpcService());
        copierOpts.setTimerManager(this.node.getTimerManager());
        copierOpts.setRaftOptions(this.node.getRaftOptions());
        copierOpts.setGroupId(this.node.getGroupId());
        return copierOpts;
    }

    @Override
    public void interruptDownloadingSnapshots(long newTerm) {
        this.lock.lock();
        try {
            Requires.requireTrue(newTerm >= this.term);
            this.term = newTerm;
            if (this.downloadingSnapshot.get() == null) {
                return;
            }
            if (this.loadingSnapshot) {
                return;
            }
            Requires.requireNonNull(this.curCopier, "curCopier");
            this.curCopier.cancel();
            LOG.info("Trying to cancel downloading snapshot: {}.", (Object)this.downloadingSnapshot.get().request);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void reportError(int errCode, String fmt, Object ... args) {
        RaftException error = new RaftException(EnumOutter.ErrorType.ERROR_TYPE_SNAPSHOT);
        error.setStatus(new Status(errCode, fmt, args));
        this.fsmCaller.onError(error);
    }

    @Override
    public boolean isInstallingSnapshot() {
        return this.downloadingSnapshot.get() != null;
    }

    @Override
    public SnapshotStorage getSnapshotStorage() {
        return this.snapshotStorage;
    }

    @Override
    public void join() throws InterruptedException {
        this.runningJobs.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void describe(Describer.Printer out) {
        boolean _stopped;
        boolean _loadingSnapshot;
        boolean _savingSnapshot;
        long _term;
        long _lastSnapshotIndex;
        long _lastSnapshotTerm;
        this.lock.lock();
        try {
            _lastSnapshotTerm = this.lastSnapshotTerm;
            _lastSnapshotIndex = this.lastSnapshotIndex;
            _term = this.term;
            _savingSnapshot = this.savingSnapshot;
            _loadingSnapshot = this.loadingSnapshot;
            _stopped = this.stopped;
        }
        finally {
            this.lock.unlock();
        }
        out.print("  lastSnapshotTerm: ").println(_lastSnapshotTerm);
        out.print("  lastSnapshotIndex: ").println(_lastSnapshotIndex);
        out.print("  term: ").println(_term);
        out.print("  savingSnapshot: ").println(_savingSnapshot);
        out.print("  loadingSnapshot: ").println(_loadingSnapshot);
        out.print("  stopped: ").println(_stopped);
    }

    private class FirstSnapshotLoadDone
    implements LoadSnapshotClosure {
        SnapshotReader reader;
        CountDownLatch eventLatch;
        Status status;

        public FirstSnapshotLoadDone(SnapshotReader reader) {
            this.reader = reader;
            this.eventLatch = new CountDownLatch(1);
        }

        @Override
        public void run(Status status) {
            this.status = status;
            SnapshotExecutorImpl.this.onSnapshotLoadDone(this.status);
            this.eventLatch.countDown();
        }

        public void waitForRun() throws InterruptedException {
            this.eventLatch.await();
        }

        @Override
        public SnapshotReader start() {
            return this.reader;
        }
    }

    private class InstallSnapshotDone
    implements LoadSnapshotClosure {
        SnapshotReader reader;

        public InstallSnapshotDone(SnapshotReader reader) {
            this.reader = reader;
        }

        @Override
        public void run(Status status) {
            SnapshotExecutorImpl.this.onSnapshotLoadDone(status);
        }

        @Override
        public SnapshotReader start() {
            return this.reader;
        }
    }

    private class SaveSnapshotDone
    implements SaveSnapshotClosure {
        SnapshotWriter writer;
        Closure done;
        RaftOutter.SnapshotMeta meta;

        public SaveSnapshotDone(SnapshotWriter writer, Closure done, RaftOutter.SnapshotMeta meta) {
            this.writer = writer;
            this.done = done;
            this.meta = meta;
        }

        @Override
        public void run(Status status) {
            ThreadPoolsFactory.runInThread(SnapshotExecutorImpl.this.getNode().getGroupId(), () -> this.continueRun(status));
        }

        void continueRun(Status st) {
            int ret = SnapshotExecutorImpl.this.onSnapshotSaveDone(st, this.meta, this.writer);
            if (ret != 0 && st.isOk()) {
                st.setError(ret, "node call onSnapshotSaveDone failed", new Object[0]);
            }
            if (this.done != null) {
                ThreadPoolsFactory.runClosureInThread(SnapshotExecutorImpl.this.getNode().getGroupId(), this.done, st);
            }
        }

        @Override
        public SnapshotWriter start(RaftOutter.SnapshotMeta meta) {
            this.meta = meta;
            this.writer.setCurrentMeta(meta);
            return this.writer;
        }
    }

    static class DownloadingSnapshot {
        RpcRequests.InstallSnapshotRequest request;
        RpcRequests.InstallSnapshotResponse.Builder responseBuilder;
        RpcRequestClosure done;

        public DownloadingSnapshot(RpcRequests.InstallSnapshotRequest request, RpcRequests.InstallSnapshotResponse.Builder responseBuilder, RpcRequestClosure done) {
            this.request = request;
            this.responseBuilder = responseBuilder;
            this.done = done;
        }
    }
}

