/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import com.alipay.remoting.rpc.RpcConfigManager;
import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.RaftRpcServerFactory;
import com.alipay.sofa.jraft.util.Ints;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import com.alipay.sofa.jraft.util.ThreadPoolMetricSet;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    private static final int CPUS = SystemPropertyUtil.getInt("jraft.available_processors", Runtime.getRuntime().availableProcessors());
    public static final int MIN_CLOSURE_EXECUTOR_POOL_SIZE = SystemPropertyUtil.getInt("jraft.closure.threadpool.size.min", Utils.cpus());
    public static final int MAX_CLOSURE_EXECUTOR_POOL_SIZE = SystemPropertyUtil.getInt("jraft.closure.threadpool.size.max", Math.max(100, Utils.cpus() * 5));
    public static final int APPEND_ENTRIES_THREADS_SEND = SystemPropertyUtil.getInt("jraft.append.entries.threads.send", Math.max(16, Ints.findNextPositivePowerOfTwo(Utils.cpus() * 2)));
    public static final int MAX_APPEND_ENTRIES_TASKS_PER_THREAD = SystemPropertyUtil.getInt("jraft.max.append.entries.tasks.per.thread", 32768);
    public static final boolean USE_MPSC_SINGLE_THREAD_EXECUTOR = SystemPropertyUtil.getBoolean("jraft.use.mpsc.single.thread.executor", true);
    private static ThreadPoolExecutor CLOSURE_EXECUTOR = ThreadPoolUtil.newBuilder().poolName("JRAFT_CLOSURE_EXECUTOR").enableMetric(true).coreThreads(MIN_CLOSURE_EXECUTOR_POOL_SIZE).maximumThreads(MAX_CLOSURE_EXECUTOR_POOL_SIZE).keepAliveSeconds(60L).workQueue(new SynchronousQueue<Runnable>()).threadFactory(new NamedThreadFactory("JRaft-Closure-Executor-", true)).build();
    private static final Pattern GROUP_ID_PATTER = Pattern.compile("^[a-zA-Z][a-zA-Z0-9\\-_]*$");
    public static final int RAFT_DATA_BUF_SIZE = SystemPropertyUtil.getInt("jraft.byte_buf.size", 1024);
    public static final int MAX_COLLECTOR_SIZE_PER_THREAD = SystemPropertyUtil.getInt("jraft.max_collector_size_per_thread", 256);
    public static final String IP_ANY = "0.0.0.0";

    public static void verifyGroupId(String groupId) {
        if (StringUtils.isBlank((String)groupId)) {
            throw new IllegalArgumentException("Blank groupId");
        }
        if (!GROUP_ID_PATTER.matcher(groupId).matches()) {
            throw new IllegalArgumentException("Invalid group id, it should be started with character 'a'-'z' or 'A'-'Z',and followed with numbers, english alphabet, '-' or '_'. ");
        }
    }

    public static void registerClosureExecutorMetrics(MetricRegistry registry) {
        registry.register("raft-utils-closure-thread-pool", (Metric)new ThreadPoolMetricSet(CLOSURE_EXECUTOR));
    }

    public static Future<?> runClosureInThread(Closure done) {
        if (done == null) {
            return null;
        }
        return Utils.runClosureInThread(done, Status.OK());
    }

    public static Future<?> runInThread(Runnable runnable) {
        return CLOSURE_EXECUTOR.submit(runnable);
    }

    public static Future<?> runClosureInThread(Closure done, Status status) {
        if (done == null) {
            return null;
        }
        return Utils.runInThread(() -> {
            try {
                done.run(status);
            }
            catch (Throwable t) {
                LOG.error("Fail to run done closure", t);
            }
        });
    }

    public static int closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return 0;
        }
        try {
            closeable.close();
            return 0;
        }
        catch (IOException e) {
            LOG.error("Fail to close", (Throwable)e);
            return RaftError.EIO.getNumber();
        }
    }

    public static int cpus() {
        return CPUS;
    }

    public static long getProcessId(long fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Long.parseLong(jvmName.substring(0, index));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public static ByteBuffer expandByteBuffer(ByteBuffer buf) {
        return Utils.expandByteBufferAtLeast(buf, RAFT_DATA_BUF_SIZE);
    }

    public static ByteBuffer allocate(int size) {
        return ByteBuffer.allocate(size);
    }

    public static ByteBuffer allocate() {
        return Utils.allocate(RAFT_DATA_BUF_SIZE);
    }

    public static ByteBuffer expandByteBufferAtLeast(ByteBuffer buf, int minLength) {
        int newCapacity = minLength > RAFT_DATA_BUF_SIZE ? minLength : RAFT_DATA_BUF_SIZE;
        ByteBuffer newBuf = ByteBuffer.allocate(buf.capacity() + newCapacity);
        buf.flip();
        newBuf.put(buf);
        return newBuf;
    }

    public static ByteBuffer expandByteBufferAtMost(ByteBuffer buf, int maxLength) {
        int newCapacity = maxLength > RAFT_DATA_BUF_SIZE || maxLength <= 0 ? RAFT_DATA_BUF_SIZE : maxLength;
        ByteBuffer newBuf = ByteBuffer.allocate(buf.capacity() + newCapacity);
        buf.flip();
        newBuf.put(buf);
        return newBuf;
    }

    public static long monotonicMs() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    public static long nowMs() {
        return System.currentTimeMillis();
    }

    public static long monotonicUs() {
        return TimeUnit.NANOSECONDS.toMicros(System.nanoTime());
    }

    public static byte[] getBytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static void ensureBoltPipeline() {
        if (RpcConfigManager.dispatch_msg_list_in_default_executor()) {
            System.setProperty("bolt.rpc.dispatch-msg-list-in-default-executor", "false");
            RaftRpcServerFactory.LOG.warn("JRaft SET {} to be false for replicator pipeline optimistic.", (Object)"bolt.rpc.dispatch-msg-list-in-default-executor");
        }
    }

    public static <T> T withLockObject(T obj) {
        return Requires.requireNonNull(obj, "obj");
    }
}

