/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import com.alipay.sofa.jraft.util.CRC64;

public final class CrcUtil {
    private static final ThreadLocal<CRC64> CRC_64_THREAD_LOCAL = ThreadLocal.withInitial(CRC64::new);

    public static long crc64(byte[] array) {
        if (array != null) {
            return CrcUtil.crc64(array, 0, array.length);
        }
        return 0L;
    }

    public static long crc64(byte[] array, int offset, int length) {
        CRC64 crc32 = CRC_64_THREAD_LOCAL.get();
        crc32.update(array, offset, length);
        long ret = crc32.getValue();
        crc32.reset();
        return ret;
    }

    private CrcUtil() {
    }
}

