/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.snapshot.remote;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.core.TimerManager;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.option.CopyOptions;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.rpc.RaftClientService;
import com.alipay.sofa.jraft.rpc.RpcRequests;
import com.alipay.sofa.jraft.rpc.RpcResponseClosureAdapter;
import com.alipay.sofa.jraft.storage.SnapshotThrottle;
import com.alipay.sofa.jraft.storage.snapshot.remote.Session;
import com.alipay.sofa.jraft.util.ByteBufferCollector;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.OnlyForTest;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.Utils;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BoltSession
implements Session {
    private static final Logger LOG = LoggerFactory.getLogger(BoltSession.class);
    private final Lock lock = new ReentrantLock();
    private final Status st = Status.OK();
    private final CountDownLatch finishLatch = new CountDownLatch(1);
    private final GetFileResponseClosure done = new GetFileResponseClosure();
    private final RaftClientService rpcService;
    private final RpcRequests.GetFileRequest.Builder requestBuilder;
    private final Endpoint endpoint;
    private final TimerManager timerManager;
    private final SnapshotThrottle snapshotThrottle;
    private final RaftOptions raftOptions;
    private int retryTimes = 0;
    private boolean finished;
    private ByteBufferCollector destBuf;
    private CopyOptions copyOptions = new CopyOptions();
    private OutputStream outputStream;
    private ScheduledFuture<?> timer;
    private String destPath;
    private Future<Message> rpcCall;

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    @OnlyForTest
    GetFileResponseClosure getDone() {
        return this.done;
    }

    @OnlyForTest
    Future<Message> getRpcCall() {
        return this.rpcCall;
    }

    @OnlyForTest
    ScheduledFuture<?> getTimer() {
        return this.timer;
    }

    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            if (!this.finished) {
                Utils.closeQuietly(this.outputStream);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public BoltSession(RaftClientService rpcService, TimerManager timerManager, SnapshotThrottle snapshotThrottle, RaftOptions raftOptions, RpcRequests.GetFileRequest.Builder rb, Endpoint ep) {
        this.snapshotThrottle = snapshotThrottle;
        this.raftOptions = raftOptions;
        this.timerManager = timerManager;
        this.rpcService = rpcService;
        this.requestBuilder = rb;
        this.endpoint = ep;
    }

    public void setDestBuf(ByteBufferCollector bufRef) {
        this.destBuf = bufRef;
    }

    public void setCopyOptions(CopyOptions copyOptions) {
        this.copyOptions = copyOptions;
    }

    public void setOutputStream(OutputStream out) {
        this.outputStream = out;
    }

    @Override
    public void cancel() {
        this.lock.lock();
        try {
            if (this.finished) {
                return;
            }
            if (this.timer != null) {
                this.timer.cancel(true);
            }
            if (this.rpcCall != null) {
                this.rpcCall.cancel(true);
            }
            if (this.st.isOk()) {
                this.st.setError(RaftError.ECANCELED, RaftError.ECANCELED.name(), new Object[0]);
            }
            this.onFinished();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void join() throws InterruptedException {
        this.finishLatch.await();
    }

    @Override
    public Status status() {
        return this.st;
    }

    private void onFinished() {
        if (!this.finished) {
            if (!this.st.isOk()) {
                LOG.error("Fail to copy data, readerId={} fileName={} offset={} status={}", new Object[]{this.requestBuilder.getReaderId(), this.requestBuilder.getFilename(), this.requestBuilder.getOffset(), this.st});
            }
            if (this.outputStream != null) {
                Utils.closeQuietly(this.outputStream);
                this.outputStream = null;
            }
            if (this.destBuf != null) {
                ByteBuffer buf = this.destBuf.getBuffer();
                if (buf != null) {
                    buf.flip();
                }
                this.destBuf = null;
            }
            this.finished = true;
            this.finishLatch.countDown();
        }
    }

    private void onTimer() {
        Utils.runInThread(this::sendNextRpc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onRpcReturned(Status status, RpcRequests.GetFileResponse response) {
        this.lock.lock();
        try {
            if (this.finished) {
                return;
            }
            if (!status.isOk()) {
                this.requestBuilder.setCount(0L);
                if (status.getCode() == RaftError.ECANCELED.getNumber() && this.st.isOk()) {
                    this.st.setError(status.getCode(), status.getErrorMsg(), new Object[0]);
                    this.onFinished();
                    return;
                }
                if (status.getCode() != RaftError.EAGAIN.getNumber() && ++this.retryTimes >= this.copyOptions.getMaxRetry() && this.st.isOk()) {
                    this.st.setError(status.getCode(), status.getErrorMsg(), new Object[0]);
                    this.onFinished();
                    return;
                }
                this.timer = this.timerManager.schedule(this::onTimer, this.copyOptions.getRetryIntervalMs(), TimeUnit.MILLISECONDS);
                return;
            }
            this.retryTimes = 0;
            Requires.requireNonNull(response, "response");
            if (!response.getEof()) {
                this.requestBuilder.setCount(response.getReadSize());
            }
            if (this.outputStream != null) {
                try {
                    response.getData().writeTo(this.outputStream);
                }
                catch (IOException e) {
                    LOG.error("Fail to write into file {}", (Object)this.destPath);
                    this.st.setError(RaftError.EIO, RaftError.EIO.name(), new Object[0]);
                    this.onFinished();
                    this.lock.unlock();
                    return;
                }
            } else {
                this.destBuf.put(response.getData().asReadOnlyByteBuffer());
            }
            if (response.getEof()) {
                this.onFinished();
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.sendNextRpc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNextRpc() {
        this.lock.lock();
        try {
            this.timer = null;
            long offset = this.requestBuilder.getOffset() + this.requestBuilder.getCount();
            long maxCount = this.destBuf == null ? (long)this.raftOptions.getMaxByteCountPerRpc() : Integer.MAX_VALUE;
            this.requestBuilder.setOffset(offset).setCount(maxCount).setReadPartly(true);
            if (this.finished) {
                return;
            }
            long newMaxCount = maxCount;
            if (this.snapshotThrottle != null && (newMaxCount = this.snapshotThrottle.throttledByThroughput(maxCount)) == 0L) {
                this.requestBuilder.setCount(0L);
                this.timer = this.timerManager.schedule(this::onTimer, this.copyOptions.getRetryIntervalMs(), TimeUnit.MILLISECONDS);
                return;
            }
            this.requestBuilder.setCount(newMaxCount);
            RpcRequests.GetFileRequest request = this.requestBuilder.build();
            LOG.debug("Send get file request {} to peer {}", (Object)request, (Object)this.endpoint);
            this.rpcCall = this.rpcService.getFile(this.endpoint, request, this.copyOptions.getTimeoutMs(), this.done);
        }
        finally {
            this.lock.unlock();
        }
    }

    private class GetFileResponseClosure
    extends RpcResponseClosureAdapter<RpcRequests.GetFileResponse> {
        private GetFileResponseClosure() {
        }

        @Override
        public void run(Status status) {
            BoltSession.this.onRpcReturned(status, (RpcRequests.GetFileResponse)this.getResponse());
        }
    }
}

