/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Lifecycle;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.ConfigurationEntry;
import com.alipay.sofa.jraft.entity.LogEntry;
import com.alipay.sofa.jraft.entity.LogId;
import com.alipay.sofa.jraft.entity.RaftOutter;
import com.alipay.sofa.jraft.option.LogManagerOptions;
import com.alipay.sofa.jraft.util.Describer;
import java.util.List;

public interface LogManager
extends Lifecycle<LogManagerOptions>,
Describer {
    public void addLastLogIndexListener(LastLogIndexListener var1);

    public void removeLastLogIndexListener(LastLogIndexListener var1);

    public void join() throws InterruptedException;

    public void appendEntries(List<LogEntry> var1, StableClosure var2);

    public void setSnapshot(RaftOutter.SnapshotMeta var1);

    public void clearBufferedLogs();

    public LogEntry getEntry(long var1);

    public long getTerm(long var1);

    public long getFirstLogIndex();

    public long getLastLogIndex();

    public long getLastLogIndex(boolean var1);

    public LogId getLastLogId(boolean var1);

    public ConfigurationEntry getConfiguration(long var1);

    public ConfigurationEntry checkAndSetConfiguration(ConfigurationEntry var1);

    public long wait(long var1, onNewLogCallback var3, Object var4);

    public boolean removeWaiter(long var1);

    public void setAppliedId(LogId var1);

    public Status checkConsistency();

    public static interface onNewLogCallback {
        public boolean onNewLog(Object var1, int var2);
    }

    public static interface LastLogIndexListener {
        public void onLastLogIndexChanged(long var1);
    }

    public static abstract class StableClosure
    implements Closure {
        protected long firstLogIndex = 0L;
        protected List<LogEntry> entries;
        protected int nEntries;

        public StableClosure() {
        }

        public long getFirstLogIndex() {
            return this.firstLogIndex;
        }

        public void setFirstLogIndex(long firstLogIndex) {
            this.firstLogIndex = firstLogIndex;
        }

        public List<LogEntry> getEntries() {
            return this.entries;
        }

        public void setEntries(List<LogEntry> entries) {
            this.entries = entries;
            this.nEntries = entries != null ? entries.size() : 0;
        }

        public StableClosure(List<LogEntry> entries) {
            this.setEntries(entries);
        }
    }
}

