/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc;

import com.alipay.remoting.CustomSerializer;
import com.alipay.remoting.CustomSerializerManager;
import com.alipay.sofa.jraft.error.MessageClassNotFoundException;
import com.alipay.sofa.jraft.rpc.ProtobufSerializer;
import com.alipay.sofa.jraft.storage.io.ProtoBufFile;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.SerializationException;

public class ProtobufMsgFactory {
    private static Map<String, MethodHandle> PARSE_METHODS_4PROTO = new HashMap<String, MethodHandle>();
    private static Map<String, MethodHandle> PARSE_METHODS_4J = new HashMap<String, MethodHandle>();

    public static void load() {
        if (PARSE_METHODS_4J.isEmpty() || PARSE_METHODS_4PROTO.isEmpty()) {
            throw new IllegalStateException("Parse protocol file failed.");
        }
    }

    public static <T extends Message> T newMessageByJavaClassName(String className, byte[] bs) {
        MethodHandle handle = PARSE_METHODS_4J.get(className);
        if (handle == null) {
            throw new MessageClassNotFoundException(className + " not found");
        }
        try {
            return (T)handle.invoke(bs);
        }
        catch (Throwable t) {
            throw new SerializationException(t);
        }
    }

    public static <T extends Message> T newMessageByProtoClassName(String className, byte[] bs) {
        MethodHandle handle = PARSE_METHODS_4PROTO.get(className);
        if (handle == null) {
            throw new MessageClassNotFoundException(className + " not found");
        }
        try {
            return (T)handle.invoke(bs);
        }
        catch (Throwable t) {
            throw new SerializationException(t);
        }
    }

    static {
        try {
            DescriptorProtos.FileDescriptorSet descriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)ProtoBufFile.class.getResourceAsStream("/raft.desc"));
            ArrayList<Descriptors.FileDescriptor> resolveFDs = new ArrayList<Descriptors.FileDescriptor>();
            for (DescriptorProtos.FileDescriptorProto fdp : descriptorSet.getFileList()) {
                Descriptors.FileDescriptor[] dependencies = new Descriptors.FileDescriptor[resolveFDs.size()];
                resolveFDs.toArray(dependencies);
                Descriptors.FileDescriptor fd = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fdp, (Descriptors.FileDescriptor[])dependencies);
                resolveFDs.add(fd);
                for (Descriptors.Descriptor descriptor : fd.getMessageTypes()) {
                    String className = fdp.getOptions().getJavaPackage() + "." + fdp.getOptions().getJavaOuterClassname() + "$" + descriptor.getName();
                    Class<?> clazz = Class.forName(className);
                    MethodHandle methodHandle = MethodHandles.lookup().findStatic(clazz, "parseFrom", MethodType.methodType(clazz, byte[].class));
                    PARSE_METHODS_4PROTO.put(descriptor.getFullName(), methodHandle);
                    PARSE_METHODS_4J.put(className, methodHandle);
                    CustomSerializerManager.registerCustomSerializer((String)className, (CustomSerializer)ProtobufSerializer.INSTANCE);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

