/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.entity.codec.v2;

import com.alipay.sofa.jraft.JRaftUtils;
import com.alipay.sofa.jraft.entity.LogEntry;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.entity.codec.LogEntryDecoder;
import com.alipay.sofa.jraft.entity.codec.v2.LogEntryV2CodecFactory;
import com.alipay.sofa.jraft.entity.codec.v2.LogOutter;
import com.alipay.sofa.jraft.util.AsciiStringUtil;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ZeroByteStringHelper;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V2Decoder
implements LogEntryDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(V2Decoder.class);
    public static final V2Decoder INSTANCE = new V2Decoder();

    @Override
    public LogEntry decode(byte[] bs) {
        int i;
        if (bs == null || bs.length < LogEntryV2CodecFactory.HEADER_SIZE) {
            return null;
        }
        for (i = 0; i < LogEntryV2CodecFactory.MAGIC_BYTES.length; ++i) {
            if (bs[i] == LogEntryV2CodecFactory.MAGIC_BYTES[i]) continue;
            return null;
        }
        if (bs[i++] != 1) {
            return null;
        }
        i += LogEntryV2CodecFactory.RESERVED.length;
        try {
            ByteString data;
            ArrayList<PeerId> peers;
            LogOutter.PBLogEntry entry = LogOutter.PBLogEntry.parseFrom(ZeroByteStringHelper.wrap(bs, i, bs.length - i));
            LogEntry log = new LogEntry();
            log.setType(entry.getType());
            log.getId().setIndex(entry.getIndex());
            log.getId().setTerm(entry.getTerm());
            if (entry.hasChecksum()) {
                log.setChecksum(entry.getChecksum());
            }
            if (entry.getPeersCount() > 0) {
                peers = new ArrayList<PeerId>(entry.getPeersCount());
                for (ByteString bstring : entry.getPeersList()) {
                    peers.add(JRaftUtils.getPeerId(AsciiStringUtil.unsafeDecode(bstring)));
                }
                log.setPeers(peers);
            }
            if (entry.getOldPeersCount() > 0) {
                peers = new ArrayList(entry.getOldPeersCount());
                for (ByteString bstring : entry.getOldPeersList()) {
                    peers.add(JRaftUtils.getPeerId(AsciiStringUtil.unsafeDecode(bstring)));
                }
                log.setOldPeers(peers);
            }
            if (!(data = entry.getData()).isEmpty()) {
                log.setData(ByteBuffer.wrap(ZeroByteStringHelper.getByteArray(data)));
            }
            return log;
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Fail to decode pb log entry", (Throwable)e);
            return null;
        }
    }

    private V2Decoder() {
    }
}

