/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.entity.codec.v1;

import com.alipay.sofa.jraft.entity.EnumOutter;
import com.alipay.sofa.jraft.entity.LogEntry;
import com.alipay.sofa.jraft.entity.LogId;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.entity.codec.LogEntryEncoder;
import com.alipay.sofa.jraft.util.AsciiStringUtil;
import com.alipay.sofa.jraft.util.Bits;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class V1Encoder
implements LogEntryEncoder {
    public static LogEntryEncoder INSTANCE = new V1Encoder();

    private V1Encoder() {
    }

    @Override
    public byte[] encode(LogEntry log) {
        byte[] ps;
        EnumOutter.EntryType type = log.getType();
        LogId id = log.getId();
        List<PeerId> peers = log.getPeers();
        List<PeerId> oldPeers = log.getOldPeers();
        ByteBuffer data = log.getData();
        int totalLen = 1;
        int iType = type.getNumber();
        long index = id.getIndex();
        long term = id.getTerm();
        totalLen += 20;
        int peerCount = 0;
        totalLen += 4;
        ArrayList<Object> peerStrs = new ArrayList<Object>(peerCount);
        if (peers != null) {
            peerCount = peers.size();
            for (PeerId peer : peers) {
                String peerStr = peer.toString();
                totalLen += 2 + peerStr.length();
                peerStrs.add(peerStr);
            }
        }
        int oldPeerCount = 0;
        totalLen += 4;
        ArrayList<String> oldPeerStrs = new ArrayList<String>(oldPeerCount);
        if (oldPeers != null) {
            oldPeerCount = oldPeers.size();
            for (PeerId peer : oldPeers) {
                String peerStr = peer.toString();
                totalLen += 2 + peerStr.length();
                oldPeerStrs.add(peerStr);
            }
        }
        int bodyLen = data != null ? data.remaining() : 0;
        byte[] content = new byte[totalLen += bodyLen];
        content[0] = -72;
        Bits.putInt(content, 1, iType);
        Bits.putLong(content, 5, index);
        Bits.putLong(content, 13, term);
        Bits.putInt(content, 21, peerCount);
        int pos = 25;
        for (String string : peerStrs) {
            ps = AsciiStringUtil.unsafeEncode(string);
            Bits.putShort(content, pos, (short)string.length());
            System.arraycopy(ps, 0, content, pos + 2, ps.length);
            pos += 2 + ps.length;
        }
        Bits.putInt(content, pos, oldPeerCount);
        pos += 4;
        for (String string : oldPeerStrs) {
            ps = AsciiStringUtil.unsafeEncode(string);
            Bits.putShort(content, pos, (short)string.length());
            System.arraycopy(ps, 0, content, pos + 2, ps.length);
            pos += 2 + ps.length;
        }
        if (data != null) {
            System.arraycopy(data.array(), data.position(), content, pos, data.remaining());
        }
        return content;
    }
}

