/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.core;

import com.alipay.remoting.util.ConcurrentHashSet;
import com.alipay.sofa.jraft.ReplicatorGroup;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.closure.CatchUpClosure;
import com.alipay.sofa.jraft.conf.ConfigurationEntry;
import com.alipay.sofa.jraft.core.NodeImpl;
import com.alipay.sofa.jraft.core.Replicator;
import com.alipay.sofa.jraft.entity.NodeId;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.option.ReplicatorGroupOptions;
import com.alipay.sofa.jraft.option.ReplicatorOptions;
import com.alipay.sofa.jraft.rpc.RpcRequests;
import com.alipay.sofa.jraft.rpc.RpcResponseClosure;
import com.alipay.sofa.jraft.util.Describer;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.ThreadId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatorGroupImpl
implements ReplicatorGroup {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicatorGroupImpl.class);
    private final ConcurrentMap<PeerId, ThreadId> replicatorMap = new ConcurrentHashMap<PeerId, ThreadId>();
    private ReplicatorOptions commonOptions;
    private int dynamicTimeoutMs = -1;
    private int electionTimeoutMs = -1;
    private RaftOptions raftOptions;
    private final Set<PeerId> failureReplicators = new ConcurrentHashSet();

    @Override
    public boolean init(NodeId nodeId, ReplicatorGroupOptions opts) {
        this.dynamicTimeoutMs = opts.getHeartbeatTimeoutMs();
        this.electionTimeoutMs = opts.getElectionTimeoutMs();
        this.raftOptions = opts.getRaftOptions();
        this.commonOptions = new ReplicatorOptions();
        this.commonOptions.setDynamicHeartBeatTimeoutMs(this.dynamicTimeoutMs);
        this.commonOptions.setElectionTimeoutMs(this.electionTimeoutMs);
        this.commonOptions.setRaftRpcService(opts.getRaftRpcClientService());
        this.commonOptions.setLogManager(opts.getLogManager());
        this.commonOptions.setBallotBox(opts.getBallotBox());
        this.commonOptions.setNode(opts.getNode());
        this.commonOptions.setTerm(0L);
        this.commonOptions.setGroupId(nodeId.getGroupId());
        this.commonOptions.setServerId(nodeId.getPeerId());
        this.commonOptions.setSnapshotStorage(opts.getSnapshotStorage());
        this.commonOptions.setRaftRpcService(opts.getRaftRpcClientService());
        this.commonOptions.setTimerManager(opts.getTimerManager());
        return true;
    }

    @Override
    public void sendHeartbeat(PeerId peer, RpcResponseClosure<RpcRequests.AppendEntriesResponse> closure) {
        ThreadId rid = (ThreadId)this.replicatorMap.get(peer);
        if (rid == null) {
            if (closure != null) {
                closure.run(new Status(RaftError.EHOSTDOWN, "Peer %s is not connected", peer));
            }
            return;
        }
        Replicator.sendHeartbeat(rid, closure);
    }

    @Override
    public ThreadId getReplicator(PeerId peer) {
        return (ThreadId)this.replicatorMap.get(peer);
    }

    @Override
    public boolean addReplicator(PeerId peer) {
        Requires.requireTrue(this.commonOptions.getTerm() != 0L);
        if (this.replicatorMap.containsKey(peer)) {
            this.failureReplicators.remove(peer);
            return true;
        }
        ReplicatorOptions opts = this.commonOptions.copy();
        opts.setPeerId(peer);
        ThreadId rid = Replicator.start(opts, this.raftOptions);
        if (rid == null) {
            LOG.error("Fail to start replicator to peer={}.", (Object)peer);
            this.failureReplicators.add(peer);
            return false;
        }
        return this.replicatorMap.put(peer, rid) == null;
    }

    @Override
    public void clearFailureReplicators() {
        this.failureReplicators.clear();
    }

    @Override
    public boolean waitCaughtUp(PeerId peer, long maxMargin, long dueTime, CatchUpClosure done) {
        ThreadId rid = (ThreadId)this.replicatorMap.get(peer);
        if (rid == null) {
            return false;
        }
        Replicator.waitForCaughtUp(rid, maxMargin, dueTime, done);
        return true;
    }

    @Override
    public long getLastRpcSendTimestamp(PeerId peer) {
        ThreadId rid = (ThreadId)this.replicatorMap.get(peer);
        if (rid == null) {
            return 0L;
        }
        return Replicator.getLastRpcSendTimestamp(rid);
    }

    @Override
    public boolean stopAll() {
        ArrayList rids = new ArrayList(this.replicatorMap.values());
        this.replicatorMap.clear();
        this.failureReplicators.clear();
        for (ThreadId rid : rids) {
            Replicator.stop(rid);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkReplicator(PeerId peer, boolean lockNode) {
        ThreadId rid = (ThreadId)this.replicatorMap.get(peer);
        if (rid == null) {
            NodeImpl node = this.commonOptions.getNode();
            if (lockNode) {
                node.writeLock.lock();
            }
            try {
                if (node.isLeader() && this.failureReplicators.contains(peer) && this.addReplicator(peer)) {
                    this.failureReplicators.remove(peer);
                }
            }
            finally {
                if (lockNode) {
                    node.writeLock.unlock();
                }
            }
        }
    }

    @Override
    public boolean stopReplicator(PeerId peer) {
        LOG.info("Stop replicator to {}.", (Object)peer);
        this.failureReplicators.remove(peer);
        ThreadId rid = (ThreadId)this.replicatorMap.remove(peer);
        if (rid == null) {
            return false;
        }
        return Replicator.stop(rid);
    }

    @Override
    public boolean resetTerm(long newTerm) {
        if (newTerm <= this.commonOptions.getTerm()) {
            return false;
        }
        this.commonOptions.setTerm(newTerm);
        return true;
    }

    @Override
    public boolean resetHeartbeatInterval(int newIntervalMs) {
        this.dynamicTimeoutMs = newIntervalMs;
        return true;
    }

    @Override
    public boolean resetElectionTimeoutInterval(int newIntervalMs) {
        this.electionTimeoutMs = newIntervalMs;
        return true;
    }

    @Override
    public boolean contains(PeerId peer) {
        return this.replicatorMap.containsKey(peer);
    }

    @Override
    public boolean transferLeadershipTo(PeerId peer, long logIndex) {
        ThreadId rid = (ThreadId)this.replicatorMap.get(peer);
        return rid != null && Replicator.transferLeadership(rid, logIndex);
    }

    @Override
    public boolean stopTransferLeadership(PeerId peer) {
        ThreadId rid = (ThreadId)this.replicatorMap.get(peer);
        return rid != null && Replicator.stopTransferLeadership(rid);
    }

    @Override
    public ThreadId stopAllAndFindTheNextCandidate(ConfigurationEntry conf) {
        ThreadId candidate = null;
        PeerId candidateId = this.findTheNextCandidate(conf);
        if (candidateId != null) {
            candidate = (ThreadId)this.replicatorMap.get(candidateId);
        } else {
            LOG.info("Fail to find the next candidate.");
        }
        for (ThreadId r : this.replicatorMap.values()) {
            if (r == candidate) continue;
            Replicator.stop(r);
        }
        this.replicatorMap.clear();
        this.failureReplicators.clear();
        return candidate;
    }

    @Override
    public PeerId findTheNextCandidate(ConfigurationEntry conf) {
        PeerId peerId = null;
        long maxIndex = -1L;
        for (Map.Entry entry : this.replicatorMap.entrySet()) {
            long nextIndex;
            if (!conf.contains((PeerId)entry.getKey()) || (nextIndex = Replicator.getNextIndex((ThreadId)entry.getValue())) <= maxIndex) continue;
            maxIndex = nextIndex;
            peerId = (PeerId)entry.getKey();
        }
        if (maxIndex == -1L) {
            return null;
        }
        return peerId;
    }

    @Override
    public List<ThreadId> listReplicators() {
        return new ArrayList<ThreadId>(this.replicatorMap.values());
    }

    @Override
    public void describe(Describer.Printer out) {
        out.print("  replicators: ").println(this.replicatorMap.values());
        out.print("  failureReplicators: ").println(this.failureReplicators);
    }
}

