/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import com.alipay.sofa.jraft.util.LogThreadPoolExecutor;
import com.alipay.sofa.jraft.util.MetricThreadPoolExecutor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ThreadPoolUtil {
    private static final RejectedExecutionHandler defaultHandler = new ThreadPoolExecutor.AbortPolicy();

    public static ThreadPoolExecutor newThreadPool(String poolName, boolean enableMetric, int coreThreads, int maximumThreads, long keepAliveSeconds, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        return ThreadPoolUtil.newThreadPool(poolName, enableMetric, coreThreads, maximumThreads, keepAliveSeconds, workQueue, threadFactory, defaultHandler);
    }

    public static ThreadPoolExecutor newThreadPool(String poolName, boolean enableMetric, int coreThreads, int maximumThreads, long keepAliveSeconds, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        TimeUnit unit = TimeUnit.SECONDS;
        if (enableMetric) {
            return new MetricThreadPoolExecutor(coreThreads, maximumThreads, keepAliveSeconds, unit, workQueue, threadFactory, handler, poolName);
        }
        return new LogThreadPoolExecutor(coreThreads, maximumThreads, keepAliveSeconds, unit, workQueue, threadFactory, handler, poolName);
    }

    private ThreadPoolUtil() {
    }
}

