/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import com.lmax.disruptor.ExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogExceptionHandler<T>
implements ExceptionHandler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(LogExceptionHandler.class);
    private final String name;
    private final OnEventException<T> onEventException;

    public LogExceptionHandler(String name) {
        this(name, null);
    }

    public LogExceptionHandler(String name, OnEventException<T> onEventException) {
        this.name = name;
        this.onEventException = onEventException;
    }

    public void handleOnStartException(Throwable ex) {
        LOG.error("Fail to start {} disruptor", (Object)this.name, (Object)ex);
    }

    public void handleOnShutdownException(Throwable ex) {
        LOG.error("Fail to shutdown {}r disruptor", (Object)this.name, (Object)ex);
    }

    public void handleEventException(Throwable ex, long sequence, T event) {
        LOG.error("Handle {} disruptor event error, event is {}", new Object[]{this.name, event, ex});
        if (this.onEventException != null) {
            this.onEventException.onException(event, ex);
        }
    }

    public static interface OnEventException<T> {
        public void onException(T var1, Throwable var2);
    }
}

