/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl.cli;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.CliRequests;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcResponseFactory;
import com.alipay.sofa.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import com.google.protobuf.Message;
import java.util.concurrent.Executor;

public class TransferLeaderRequestProcessor
extends BaseCliRequestProcessor<CliRequests.TransferLeaderRequest> {
    public TransferLeaderRequestProcessor(Executor executor) {
        super(executor);
    }

    @Override
    protected String getPeerId(CliRequests.TransferLeaderRequest request) {
        return request.getLeaderId();
    }

    @Override
    protected String getGroupId(CliRequests.TransferLeaderRequest request) {
        return request.getGroupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.TransferLeaderRequest request, RpcRequestClosure done) {
        PeerId peer = new PeerId();
        if (request.hasPeerId() && !peer.parse(request.getPeerId())) {
            return RpcResponseFactory.newResponse(RaftError.EINVAL, "Fail to parse peer id %s", request.getPeerId());
        }
        LOG.info("Receive TransferLeaderRequest to {} from {} , newLeader will be {}", new Object[]{ctx.node.getNodeId(), done.getBizContext().getRemoteAddress(), peer});
        Status st = ctx.node.transferLeadershipTo(peer);
        return RpcResponseFactory.newResponse(st);
    }

    public String interest() {
        return CliRequests.TransferLeaderRequest.class.getName();
    }
}

