/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.entity;

import com.alipay.sofa.jraft.entity.EnumOutter;
import com.alipay.sofa.jraft.entity.LogId;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.util.AsciiStringUtil;
import com.alipay.sofa.jraft.util.Bits;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class LogEntry {
    private EnumOutter.EntryType type;
    private LogId id = new LogId(0L, 0L);
    private List<PeerId> peers;
    private List<PeerId> oldPeers;
    private ByteBuffer data;
    public static final byte MAGIC = -72;

    public LogEntry() {
    }

    public LogEntry(EnumOutter.EntryType type) {
        this.type = type;
    }

    public byte[] encode() {
        byte[] ps;
        int totalLen = 1;
        int iType = this.type.getNumber();
        long index = this.id.getIndex();
        long term = this.id.getTerm();
        totalLen += 20;
        int peerCount = 0;
        totalLen += 4;
        ArrayList<Object> peerStrs = new ArrayList<Object>(peerCount);
        if (this.peers != null) {
            peerCount = this.peers.size();
            for (PeerId peer : this.peers) {
                String peerStr = peer.toString();
                totalLen += 2 + peerStr.length();
                peerStrs.add(peerStr);
            }
        }
        int oldPeerCount = 0;
        totalLen += 4;
        ArrayList<String> oldPeerStrs = new ArrayList<String>(oldPeerCount);
        if (this.oldPeers != null) {
            oldPeerCount = this.oldPeers.size();
            for (PeerId peer : this.oldPeers) {
                String peerStr = peer.toString();
                totalLen += 2 + peerStr.length();
                oldPeerStrs.add(peerStr);
            }
        }
        int bodyLen = this.data != null ? this.data.remaining() : 0;
        byte[] content = new byte[totalLen += bodyLen];
        content[0] = -72;
        Bits.putInt(content, 1, iType);
        Bits.putLong(content, 5, index);
        Bits.putLong(content, 13, term);
        Bits.putInt(content, 21, peerCount);
        int pos = 25;
        for (String string : peerStrs) {
            ps = AsciiStringUtil.unsafeEncode(string);
            Bits.putShort(content, pos, (short)string.length());
            System.arraycopy(ps, 0, content, pos + 2, ps.length);
            pos += 2 + ps.length;
        }
        Bits.putInt(content, pos, oldPeerCount);
        pos += 4;
        for (String string : oldPeerStrs) {
            ps = AsciiStringUtil.unsafeEncode(string);
            Bits.putShort(content, pos, (short)string.length());
            System.arraycopy(ps, 0, content, pos + 2, ps.length);
            pos += 2 + ps.length;
        }
        if (this.data != null) {
            System.arraycopy(this.data.array(), this.data.position(), content, pos, this.data.remaining());
        }
        return content;
    }

    public boolean decode(byte[] content) {
        if (content == null || content.length == 0) {
            return false;
        }
        if (content[0] != -72) {
            return false;
        }
        int iType = Bits.getInt(content, 1);
        this.type = EnumOutter.EntryType.forNumber(iType);
        long index = Bits.getLong(content, 5);
        long term = Bits.getLong(content, 13);
        this.id = new LogId(index, term);
        int peerCount = Bits.getInt(content, 21);
        int pos = 25;
        if (peerCount > 0) {
            this.peers = new ArrayList<PeerId>(peerCount);
            while (peerCount-- > 0) {
                short len = Bits.getShort(content, pos);
                byte[] bs = new byte[len];
                System.arraycopy(content, pos + 2, bs, 0, len);
                pos += 2 + len;
                PeerId peer = new PeerId();
                peer.parse(AsciiStringUtil.unsafeDecode(bs));
                this.peers.add(peer);
            }
        }
        int oldPeerCount = Bits.getInt(content, pos);
        pos += 4;
        if (oldPeerCount > 0) {
            this.oldPeers = new ArrayList<PeerId>(oldPeerCount);
            while (oldPeerCount-- > 0) {
                short len = Bits.getShort(content, pos);
                byte[] bs = new byte[len];
                System.arraycopy(content, pos + 2, bs, 0, len);
                pos += 2 + len;
                PeerId peer = new PeerId();
                peer.parse(AsciiStringUtil.unsafeDecode(bs));
                this.oldPeers.add(peer);
            }
        }
        if (content.length > pos) {
            int len = content.length - pos;
            this.data = ByteBuffer.allocate(len);
            this.data.put(content, pos, len);
            this.data.flip();
        }
        return true;
    }

    public EnumOutter.EntryType getType() {
        return this.type;
    }

    public void setType(EnumOutter.EntryType type) {
        this.type = type;
    }

    public LogId getId() {
        return this.id;
    }

    public void setId(LogId id) {
        this.id = id;
    }

    public List<PeerId> getPeers() {
        return this.peers;
    }

    public void setPeers(List<PeerId> peers) {
        this.peers = peers;
    }

    public List<PeerId> getOldPeers() {
        return this.oldPeers;
    }

    public void setOldPeers(List<PeerId> oldPeers) {
        this.oldPeers = oldPeers;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    public String toString() {
        return "LogEntry [type=" + (Object)((Object)this.type) + ", id=" + this.id + ", peers=" + this.peers + ", oldPeers=" + this.oldPeers + ", data=" + (this.data != null ? this.data.remaining() : 0) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.oldPeers == null ? 0 : this.oldPeers.hashCode());
        result = 31 * result + (this.peers == null ? 0 : this.peers.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogEntry other = (LogEntry)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.oldPeers == null ? other.oldPeers != null : !this.oldPeers.equals(other.oldPeers)) {
            return false;
        }
        if (this.peers == null ? other.peers != null : !this.peers.equals(other.peers)) {
            return false;
        }
        return this.type == other.type;
    }
}

