/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.hessian;

import com.alipay.hessian.CallStackUtil;
import com.alipay.hessian.ClassNameFilter;
import com.alipay.hessian.clhm.ConcurrentLinkedHashMap;
import com.alipay.sofa.common.log.LoggerSpaceManager;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;

public abstract class NameBlackListFilter
implements ClassNameFilter {
    private static Logger LOGGER = NameBlackListFilter.judgeLogger();
    public static final String HESSIAN_SERIALIZE_LOG_NAME = "HessianSerializeLog";
    public static final String CONFIG_LOG_SPACE_NAME = "com.alipay.sofa.middleware.config";
    protected List<String> blackPrefixList;
    protected static List<String> addBlackPrefixList;
    protected static ConcurrentMap<String, Boolean> resultOfInBlackList;

    private static Logger judgeLogger() {
        try {
            NameBlackListFilter.class.getClassLoader().loadClass("com.alipay.sofa.common.log.LoggerSpaceManager");
        }
        catch (Throwable e) {
            return null;
        }
        return LoggerSpaceManager.getLoggerBySpace((String)HESSIAN_SERIALIZE_LOG_NAME, (String)CONFIG_LOG_SPACE_NAME);
    }

    public NameBlackListFilter(List<String> blackPrefixList) {
        this(blackPrefixList, 8192);
    }

    public NameBlackListFilter(List<String> blackPrefixList, int maxCacheSize) {
        this.blackPrefixList = blackPrefixList;
        NameBlackListFilter.buildCache(blackPrefixList, maxCacheSize);
    }

    public static void buildCache(List<String> blackPrefixList, int maxCacheSize) {
        if (blackPrefixList != null && !blackPrefixList.isEmpty()) {
            int min = Math.min(256, maxCacheSize);
            int max = Math.min(10240, maxCacheSize);
            ConcurrentLinkedHashMap.Builder builder = new ConcurrentLinkedHashMap.Builder().initialCapacity(min).maximumWeightedCapacity(max);
            resultOfInBlackList = builder.build();
        } else {
            resultOfInBlackList = null;
        }
    }

    @Override
    public int order() {
        return 0;
    }

    @Override
    public String resolve(String className) throws IOException {
        Boolean result;
        if (this.blackPrefixList == null || resultOfInBlackList == null) {
            return className;
        }
        String monitorKey = "@" + className;
        Boolean monitorResult = (Boolean)resultOfInBlackList.get(monitorKey);
        if (monitorResult == null) {
            monitorResult = this.inBlackList(monitorKey);
            resultOfInBlackList.putIfAbsent(monitorKey, monitorResult);
        }
        if (monitorResult.booleanValue() && LOGGER != null) {
            LOGGER.info(String.format("[status] %s, [class] %s, [rule] %s, [callStack] %s", "watch", className, monitorKey, CallStackUtil.getCurrentCallStack()));
        }
        if ((result = (Boolean)resultOfInBlackList.get(className)) == null) {
            result = this.inBlackList(className);
            resultOfInBlackList.putIfAbsent(className, result);
        }
        if (result.booleanValue() && LOGGER != null) {
            LOGGER.info(String.format("[status] %s, [class] %s, [rule] %s, [callStack] %s", "control", className, className, CallStackUtil.getCurrentCallStack()));
            throw new IOException("Class " + className + " is in blacklist. ");
        }
        return className;
    }

    protected boolean inBlackList(String className) {
        if (addBlackPrefixList != null && addBlackPrefixList.size() != 0) {
            for (String prefix : addBlackPrefixList) {
                if (!className.startsWith(prefix)) continue;
                return Boolean.TRUE;
            }
        } else {
            for (String prefix : this.blackPrefixList) {
                if (!className.startsWith(prefix)) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public static void setAddBlackPrefixList(List<String> addBlackPrefixList) {
        NameBlackListFilter.addBlackPrefixList = addBlackPrefixList;
        if (resultOfInBlackList != null) {
            resultOfInBlackList.clear();
        }
    }
}

