/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc.protocol;

import com.alipay.remoting.CommandFactory;
import com.alipay.remoting.Connection;
import com.alipay.remoting.HeartbeatTrigger;
import com.alipay.remoting.InvokeCallbackListener;
import com.alipay.remoting.InvokeFuture;
import com.alipay.remoting.RemotingCommand;
import com.alipay.remoting.ResponseStatus;
import com.alipay.remoting.TimerHolder;
import com.alipay.remoting.config.ConfigManager;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.rpc.DefaultInvokeFuture;
import com.alipay.remoting.rpc.HeartbeatCommand;
import com.alipay.remoting.rpc.ResponseCommand;
import com.alipay.remoting.util.RemotingUtil;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class RpcHeartbeatTrigger
implements HeartbeatTrigger {
    private static final Logger logger = BoltLoggerFactory.getLogger("RpcRemoting");
    public static final Integer maxCount = ConfigManager.tcp_idle_maxtimes();
    private static final long heartbeatTimeoutMillis = 1000L;
    private CommandFactory commandFactory;

    public RpcHeartbeatTrigger(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    @Override
    public void heartbeatTriggered(final ChannelHandlerContext ctx) throws Exception {
        Integer heartbeatTimes = (Integer)ctx.channel().attr(Connection.HEARTBEAT_COUNT).get();
        final Connection conn = (Connection)ctx.channel().attr(Connection.CONNECTION).get();
        if (heartbeatTimes >= maxCount) {
            try {
                conn.close();
                logger.error("Heartbeat failed for {} times, close the connection from client side: {} ", (Object)heartbeatTimes, (Object)RemotingUtil.parseRemoteAddress(ctx.channel()));
            }
            catch (Exception e) {
                logger.warn("Exception caught when closing connection in SharableHandler.", (Throwable)e);
            }
        } else {
            boolean heartbeatSwitch = (Boolean)ctx.channel().attr(Connection.HEARTBEAT_SWITCH).get();
            if (!heartbeatSwitch) {
                return;
            }
            final HeartbeatCommand heartbeat = new HeartbeatCommand();
            DefaultInvokeFuture future = new DefaultInvokeFuture(heartbeat.getId(), new InvokeCallbackListener(){

                @Override
                public void onResponse(InvokeFuture future) {
                    ResponseCommand response;
                    try {
                        response = (ResponseCommand)future.waitResponse(0L);
                    }
                    catch (InterruptedException e) {
                        logger.error("Heartbeat ack process error! Id={}, from remoteAddr={}", new Object[]{heartbeat.getId(), RemotingUtil.parseRemoteAddress(ctx.channel()), e});
                        return;
                    }
                    if (response != null && response.getResponseStatus() == ResponseStatus.SUCCESS) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Heartbeat ack received! Id={}, from remoteAddr={}", (Object)response.getId(), (Object)RemotingUtil.parseRemoteAddress(ctx.channel()));
                        }
                        ctx.channel().attr(Connection.HEARTBEAT_COUNT).set((Object)0);
                    } else {
                        if (response == null) {
                            logger.error("Heartbeat timeout! The address is {}", (Object)RemotingUtil.parseRemoteAddress(ctx.channel()));
                        } else {
                            logger.error("Heartbeat exception caught! Error code={}, The address is {}", (Object)response.getResponseStatus(), (Object)RemotingUtil.parseRemoteAddress(ctx.channel()));
                        }
                        Integer times = (Integer)ctx.channel().attr(Connection.HEARTBEAT_COUNT).get();
                        ctx.channel().attr(Connection.HEARTBEAT_COUNT).set((Object)(times + 1));
                    }
                }

                @Override
                public String getRemoteAddress() {
                    return ctx.channel().remoteAddress().toString();
                }
            }, null, heartbeat.getProtocolCode().getFirstByte(), this.commandFactory);
            final int heartbeatId = heartbeat.getId();
            conn.addInvokeFuture(future);
            if (logger.isDebugEnabled()) {
                logger.debug("Send heartbeat, successive count={}, Id={}, to remoteAddr={}", new Object[]{heartbeatTimes, heartbeatId, RemotingUtil.parseRemoteAddress(ctx.channel())});
            }
            ctx.writeAndFlush((Object)heartbeat).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Send heartbeat done! Id={}, to remoteAddr={}", (Object)heartbeatId, (Object)RemotingUtil.parseRemoteAddress(ctx.channel()));
                        }
                    } else {
                        logger.error("Send heartbeat failed! Id={}, to remoteAddr={}", (Object)heartbeatId, (Object)RemotingUtil.parseRemoteAddress(ctx.channel()));
                    }
                }
            });
            TimerHolder.getTimer().newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    InvokeFuture future = conn.removeInvokeFuture(heartbeatId);
                    if (future != null) {
                        future.putResponse((RemotingCommand)RpcHeartbeatTrigger.this.commandFactory.createTimeoutResponse(conn.getRemoteAddress()));
                        future.tryAsyncExecuteInvokeCallbackAbnormally();
                    }
                }
            }, 1000L, TimeUnit.MILLISECONDS);
        }
    }
}

