/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.config;

import com.alipay.remoting.config.Configs;

public class ConfigManager {
    public static final byte serializer = ConfigManager.serializer();

    public static boolean tcp_nodelay() {
        return ConfigManager.getBool("bolt.tcp.nodelay", "true");
    }

    public static boolean tcp_so_reuseaddr() {
        return ConfigManager.getBool("bolt.tcp.so.reuseaddr", "true");
    }

    public static int tcp_so_backlog() {
        return ConfigManager.getInt("bolt.tcp.so.backlog", "1024");
    }

    public static boolean tcp_so_keepalive() {
        return ConfigManager.getBool("bolt.tcp.so.keepalive", "true");
    }

    public static int netty_io_ratio() {
        return ConfigManager.getInt("bolt.netty.io.ratio", "70");
    }

    public static boolean netty_buffer_pooled() {
        return ConfigManager.getBool("bolt.netty.buffer.pooled", "true");
    }

    public static int netty_buffer_low_watermark() {
        return ConfigManager.getInt("bolt.netty.buffer.low.watermark", Configs.NETTY_BUFFER_LOW_WATERMARK_DEFAULT);
    }

    public static int netty_buffer_high_watermark() {
        return ConfigManager.getInt("bolt.netty.buffer.high.watermark", Configs.NETTY_BUFFER_HIGH_WATERMARK_DEFAULT);
    }

    public static boolean netty_epoll() {
        return ConfigManager.getBool("bolt.netty.epoll.switch", "true");
    }

    public static boolean netty_epoll_lt_enabled() {
        return ConfigManager.getBool("bolt.netty.epoll.lt", "true");
    }

    public static boolean tcp_idle_switch() {
        return ConfigManager.getBool("bolt.tcp.heartbeat.switch", "true");
    }

    public static int tcp_idle() {
        return ConfigManager.getInt("bolt.tcp.heartbeat.interval", "15000");
    }

    public static int tcp_idle_maxtimes() {
        return ConfigManager.getInt("bolt.tcp.heartbeat.maxtimes", "3");
    }

    public static int tcp_server_idle() {
        return ConfigManager.getInt("bolt.tcp.server.idle.interval", "90000");
    }

    public static int conn_create_tp_min_size() {
        return ConfigManager.getInt("bolt.conn.create.tp.min", "3");
    }

    public static int conn_create_tp_max_size() {
        return ConfigManager.getInt("bolt.conn.create.tp.max", "8");
    }

    public static int conn_create_tp_queue_size() {
        return ConfigManager.getInt("bolt.conn.create.tp.queue", "50");
    }

    public static int conn_create_tp_keepalive() {
        return ConfigManager.getInt("bolt.conn.create.tp.keepalive", "60");
    }

    public static int default_tp_min_size() {
        return ConfigManager.getInt("bolt.tp.min", "20");
    }

    public static int default_tp_max_size() {
        return ConfigManager.getInt("bolt.tp.max", "400");
    }

    public static int default_tp_queue_size() {
        return ConfigManager.getInt("bolt.tp.queue", "600");
    }

    public static int default_tp_keepalive_time() {
        return ConfigManager.getInt("bolt.tp.keepalive", "60");
    }

    public static boolean conn_reconnect_switch() {
        return ConfigManager.getBool("bolt.conn.reconnect.switch", "false");
    }

    public static boolean conn_monitor_switch() {
        return ConfigManager.getBool("bolt.conn.monitor.switch", "false");
    }

    public static long conn_monitor_initial_delay() {
        return ConfigManager.getLong("bolt.conn.monitor.initial.delay", "10000");
    }

    public static long conn_monitor_period() {
        return ConfigManager.getLong("bolt.conn.monitor.period", "180000");
    }

    public static int conn_threshold() {
        return ConfigManager.getInt("bolt.conn.threshold", "3");
    }

    public static int retry_detect_period() {
        return ConfigManager.getInt("bolt.retry.delete.period", "5000");
    }

    public static byte serializer() {
        return ConfigManager.getByte("bolt.serializer", Configs.SERIALIZER_DEFAULT);
    }

    public static boolean getBool(String key, String defaultValue) {
        return Boolean.parseBoolean(System.getProperty(key, defaultValue));
    }

    public static int getInt(String key, String defaultValue) {
        return Integer.parseInt(System.getProperty(key, defaultValue));
    }

    public static byte getByte(String key, String defaultValue) {
        return Byte.parseByte(System.getProperty(key, defaultValue));
    }

    public static long getLong(String key, String defaultValue) {
        return Long.parseLong(System.getProperty(key, defaultValue));
    }
}

