/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventHandler;
import com.alipay.remoting.ConnectionEventListener;
import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.ConnectionFactory;
import com.alipay.remoting.ConnectionMonitorStrategy;
import com.alipay.remoting.ConnectionSelectStrategy;
import com.alipay.remoting.DefaultConnectionManager;
import com.alipay.remoting.DefaultConnectionMonitor;
import com.alipay.remoting.InvokeCallback;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.RandomSelectStrategy;
import com.alipay.remoting.ReconnectManager;
import com.alipay.remoting.RemotingAddressParser;
import com.alipay.remoting.ScheduledDisconnectStrategy;
import com.alipay.remoting.Url;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.rpc.RpcAddressParser;
import com.alipay.remoting.rpc.RpcClientRemoting;
import com.alipay.remoting.rpc.RpcCommandFactory;
import com.alipay.remoting.rpc.RpcConnectionEventHandler;
import com.alipay.remoting.rpc.RpcConnectionFactory;
import com.alipay.remoting.rpc.RpcRemoting;
import com.alipay.remoting.rpc.RpcResponseFuture;
import com.alipay.remoting.rpc.RpcTaskScanner;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.remoting.util.GlobalSwitch;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class RpcClient {
    private static final Logger logger = BoltLoggerFactory.getLogger("RpcRemoting");
    private GlobalSwitch globalSwitch = new GlobalSwitch();
    private ConnectionFactory connctionFactory = new RpcConnectionFactory();
    private ConnectionEventHandler connectionEventHandler = new RpcConnectionEventHandler(this.globalSwitch);
    private ReconnectManager reconnectManager;
    private ConnectionEventListener connectionEventListener = new ConnectionEventListener();
    private RemotingAddressParser addressParser;
    private ConnectionSelectStrategy connectionSelectStrategy = new RandomSelectStrategy(this.globalSwitch);
    private DefaultConnectionManager connectionManager = new DefaultConnectionManager(this.connectionSelectStrategy, this.connctionFactory, this.connectionEventHandler, this.connectionEventListener, this.globalSwitch);
    protected RpcRemoting rpcRemoting;
    private RpcTaskScanner taskScanner = new RpcTaskScanner();
    private DefaultConnectionMonitor connectionMonitor;
    private ConnectionMonitorStrategy monitorStrategy;

    public void init() {
        if (this.addressParser == null) {
            this.addressParser = new RpcAddressParser();
        }
        this.connectionManager.setAddressParser(this.addressParser);
        this.connectionManager.init();
        this.rpcRemoting = new RpcClientRemoting(new RpcCommandFactory(), this.addressParser, this.connectionManager);
        this.taskScanner.add(this.connectionManager);
        this.taskScanner.start();
        if (this.globalSwitch.isOn(1)) {
            if (this.monitorStrategy == null) {
                ScheduledDisconnectStrategy strategy = new ScheduledDisconnectStrategy();
                this.connectionMonitor = new DefaultConnectionMonitor(strategy, this.connectionManager);
            } else {
                this.connectionMonitor = new DefaultConnectionMonitor(this.monitorStrategy, this.connectionManager);
            }
            this.connectionMonitor.start();
            logger.warn("Switch on connection monitor");
        }
        if (this.globalSwitch.isOn(0)) {
            this.reconnectManager = new ReconnectManager(this.connectionManager);
            this.connectionEventHandler.setReconnectManager(this.reconnectManager);
            logger.warn("Switch on reconnect manager");
        }
    }

    public void shutdown() {
        this.connectionManager.removeAll();
        logger.warn("Close all connections from client side!");
        this.taskScanner.shutdown();
        logger.warn("Rpc client shutdown!");
        if (this.reconnectManager != null) {
            this.reconnectManager.stop();
        }
        if (this.connectionMonitor != null) {
            this.connectionMonitor.destroy();
        }
    }

    public void oneway(String addr, Object request) throws RemotingException, InterruptedException {
        this.rpcRemoting.oneway(addr, request, null);
    }

    public void oneway(String addr, Object request, InvokeContext invokeContext) throws RemotingException, InterruptedException {
        this.rpcRemoting.oneway(addr, request, invokeContext);
    }

    public void oneway(Url url, Object request) throws RemotingException, InterruptedException {
        this.rpcRemoting.oneway(url, request, null);
    }

    public void oneway(Url url, Object request, InvokeContext invokeContext) throws RemotingException, InterruptedException {
        this.rpcRemoting.oneway(url, request, invokeContext);
    }

    public void oneway(Connection conn, Object request) throws RemotingException {
        this.rpcRemoting.oneway(conn, request, null);
    }

    public void oneway(Connection conn, Object request, InvokeContext invokeContext) throws RemotingException {
        this.rpcRemoting.oneway(conn, request, invokeContext);
    }

    public Object invokeSync(String addr, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        return this.rpcRemoting.invokeSync(addr, request, null, timeoutMillis);
    }

    public Object invokeSync(String addr, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        return this.rpcRemoting.invokeSync(addr, request, invokeContext, timeoutMillis);
    }

    public Object invokeSync(Url url, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        return this.invokeSync(url, request, null, timeoutMillis);
    }

    public Object invokeSync(Url url, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        return this.rpcRemoting.invokeSync(url, request, invokeContext, timeoutMillis);
    }

    public Object invokeSync(Connection conn, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        return this.rpcRemoting.invokeSync(conn, request, null, timeoutMillis);
    }

    public Object invokeSync(Connection conn, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        return this.rpcRemoting.invokeSync(conn, request, invokeContext, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(String addr, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        return this.rpcRemoting.invokeWithFuture(addr, request, null, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(String addr, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        return this.rpcRemoting.invokeWithFuture(addr, request, invokeContext, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(Url url, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        return this.rpcRemoting.invokeWithFuture(url, request, null, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(Url url, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        return this.rpcRemoting.invokeWithFuture(url, request, invokeContext, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(Connection conn, Object request, int timeoutMillis) throws RemotingException {
        return this.rpcRemoting.invokeWithFuture(conn, request, null, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(Connection conn, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException {
        return this.rpcRemoting.invokeWithFuture(conn, request, invokeContext, timeoutMillis);
    }

    public void invokeWithCallback(String addr, Object request, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        this.rpcRemoting.invokeWithCallback(addr, request, null, invokeCallback, timeoutMillis);
    }

    public void invokeWithCallback(String addr, Object request, InvokeContext invokeContext, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        this.rpcRemoting.invokeWithCallback(addr, request, invokeContext, invokeCallback, timeoutMillis);
    }

    public void invokeWithCallback(Url url, Object request, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        this.rpcRemoting.invokeWithCallback(url, request, null, invokeCallback, timeoutMillis);
    }

    public void invokeWithCallback(Url url, Object request, InvokeContext invokeContext, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        this.rpcRemoting.invokeWithCallback(url, request, invokeContext, invokeCallback, timeoutMillis);
    }

    public void invokeWithCallback(Connection conn, Object request, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException {
        this.rpcRemoting.invokeWithCallback(conn, request, null, invokeCallback, timeoutMillis);
    }

    public void invokeWithCallback(Connection conn, Object request, InvokeContext invokeContext, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException {
        this.rpcRemoting.invokeWithCallback(conn, request, invokeContext, invokeCallback, timeoutMillis);
    }

    public void addConnectionEventProcessor(ConnectionEventType type, ConnectionEventProcessor processor) {
        this.connectionEventListener.addConnectionEventProcessor(type, processor);
    }

    public void registerUserProcessor(UserProcessor<?> processor) {
        this.connectionManager.getConnectionFactory().registerUserProcessor(processor);
    }

    public Connection createStandaloneConnection(String ip, int port, int connectTimeout) throws RemotingException {
        return this.connectionManager.create(ip, port, connectTimeout);
    }

    public Connection createStandaloneConnection(String addr, int connectTimeout) throws RemotingException {
        return this.connectionManager.create(addr, connectTimeout);
    }

    public void closeStandaloneConnection(Connection conn) {
        if (null != conn) {
            conn.close();
        }
    }

    public Connection getConnection(String addr, int connectTimeout) throws RemotingException, InterruptedException {
        Url url = this.addressParser.parse(addr);
        return this.getConnection(url, connectTimeout);
    }

    public Connection getConnection(Url url, int connectTimeout) throws RemotingException, InterruptedException {
        url.setConnectTimeout(connectTimeout);
        return this.connectionManager.getAndCreateIfAbsent(url);
    }

    public Map<String, List<Connection>> getAllManagedConnections() {
        return this.connectionManager.getAll();
    }

    public boolean checkConnection(String addr) {
        Url url = this.addressParser.parse(addr);
        Connection conn = this.connectionManager.get(url.getUniqueKey());
        try {
            this.connectionManager.check(conn);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void closeConnection(String addr) {
        Url url = this.addressParser.parse(addr);
        this.connectionManager.remove(url.getUniqueKey());
    }

    public void closeConnection(Url url) {
        this.connectionManager.remove(url.getUniqueKey());
    }

    public void enableConnHeartbeat(String addr) {
        Url url = this.addressParser.parse(addr);
        this.enableConnHeartbeat(url);
    }

    public void enableConnHeartbeat(Url url) {
        if (null != url) {
            this.connectionManager.enableHeartbeat(this.connectionManager.get(url.getUniqueKey()));
        }
    }

    public void disableConnHeartbeat(String addr) {
        Url url = this.addressParser.parse(addr);
        this.disableConnHeartbeat(url);
    }

    public void disableConnHeartbeat(Url url) {
        if (null != url) {
            this.connectionManager.disableHeartbeat(this.connectionManager.get(url.getUniqueKey()));
        }
    }

    public void enableReconnectSwitch() {
        this.globalSwitch.turnOn(0);
    }

    public boolean isReconnectSwitchOn() {
        return this.globalSwitch.isOn(0);
    }

    public void enableConnectionMonitorSwitch() {
        this.globalSwitch.turnOn(1);
    }

    public boolean isConnectionMonitorSwitchOn() {
        return this.globalSwitch.isOn(1);
    }

    protected DefaultConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public RemotingAddressParser getAddressParser() {
        return this.addressParser;
    }

    public void setAddressParser(RemotingAddressParser addressParser) {
        this.addressParser = addressParser;
    }

    public void setMonitorStrategy(ConnectionMonitorStrategy monitorStrategy) {
        this.monitorStrategy = monitorStrategy;
    }
}

