/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.internal.parser.json;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.CertItem;
import com.alipay.api.Decryptor;
import com.alipay.api.ResponseParseItem;
import com.alipay.api.SignItem;
import com.alipay.api.internal.mapping.Converter;
import com.alipay.api.internal.mapping.Converters;
import com.alipay.api.internal.mapping.Reader;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.internal.util.SignSourceData;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.internal.util.json.ExceptionErrorListener;
import com.alipay.api.internal.util.json.JSONReader;
import com.alipay.api.internal.util.json.JSONValidatingReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonConverter
implements Converter {
    @Override
    public <T extends AlipayResponse> T toResponse(String rsp, Class<T> clazz) throws AlipayApiException {
        JSONValidatingReader reader = new JSONValidatingReader(new ExceptionErrorListener());
        Object rootObj = ((JSONReader)reader).read(rsp);
        if (rootObj instanceof Map) {
            Map rootJson = (Map)rootObj;
            Collection values = rootJson.values();
            for (Object rspObj : values) {
                if (!(rspObj instanceof Map)) continue;
                Map rspJson = (Map)rspObj;
                return (T)((AlipayResponse)this.fromJson(rspJson, clazz));
            }
        }
        return null;
    }

    public <T> T fromJson(final Map<?, ?> json, Class<T> clazz) throws AlipayApiException {
        return Converters.convert(clazz, new Reader(){

            @Override
            public boolean hasReturnField(Object name) {
                return json.containsKey(name);
            }

            @Override
            public Object getPrimitiveObject(Object name) {
                return json.get(name);
            }

            @Override
            public Object getObject(Object name, Class<?> type) throws AlipayApiException {
                Object tmp = json.get(name);
                if (tmp instanceof Map) {
                    Map map = (Map)tmp;
                    return JsonConverter.this.fromJson(map, type);
                }
                return null;
            }

            @Override
            public List<?> getListObjects(Object listName, Object itemName, Class<?> subType) throws AlipayApiException {
                List<Object> listObjs = null;
                Object listTmp = json.get(listName);
                if (listTmp instanceof Map) {
                    Map jsonMap = (Map)listTmp;
                    Object itemTmp = jsonMap.get(itemName);
                    if (itemTmp == null && listName != null) {
                        String listNameStr = listName.toString();
                        itemTmp = jsonMap.get(listNameStr.substring(0, listNameStr.length() - 1));
                    }
                    if (itemTmp instanceof List) {
                        listObjs = this.getListObjectsInner(subType, itemTmp);
                    }
                } else if (listTmp instanceof List) {
                    listObjs = this.getListObjectsInner(subType, listTmp);
                }
                return listObjs;
            }

            private List<Object> getListObjectsInner(Class<?> subType, Object itemTmp) throws AlipayApiException {
                ArrayList<Object> listObjs = new ArrayList<Object>();
                List tmpList = (List)itemTmp;
                for (Object subTmp : tmpList) {
                    Date obj = null;
                    if (String.class.isAssignableFrom(subType)) {
                        obj = (Date)subTmp;
                    } else if (Long.class.isAssignableFrom(subType)) {
                        obj = (Date)subTmp;
                    } else if (Integer.class.isAssignableFrom(subType)) {
                        obj = (Date)subTmp;
                    } else if (Boolean.class.isAssignableFrom(subType)) {
                        obj = (Date)subTmp;
                    } else if (Date.class.isAssignableFrom(subType)) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        try {
                            obj = format.parse(String.valueOf(subTmp));
                        }
                        catch (ParseException e) {
                            throw new AlipayApiException(e);
                        }
                    } else if (subTmp instanceof Map) {
                        Map subMap = (Map)subTmp;
                        obj = JsonConverter.this.fromJson(subMap, subType);
                    }
                    if (obj == null) continue;
                    listObjs.add(obj);
                }
                return listObjs;
            }
        });
    }

    @Override
    public SignItem getSignItem(AlipayRequest<?> request, String responseBody) throws AlipayApiException {
        if (StringUtils.isEmpty(responseBody)) {
            return null;
        }
        SignItem signItem = new SignItem();
        String sign = this.getSign(responseBody);
        signItem.setSign(sign);
        String signSourceData = this.getSignSourceData(request, responseBody);
        signItem.setSignSourceDate(signSourceData);
        return signItem;
    }

    @Override
    public CertItem getCertItem(AlipayRequest<?> request, String responseBody) throws AlipayApiException {
        if (StringUtils.isEmpty(responseBody)) {
            return null;
        }
        CertItem certItem = new CertItem();
        JSONValidatingReader reader = new JSONValidatingReader(new ExceptionErrorListener());
        Object rootObj = ((JSONReader)reader).read(responseBody);
        Map rootJson = (Map)rootObj;
        String sign = (String)rootJson.get("sign");
        certItem.setSign(sign);
        String cert = (String)rootJson.get("alipay_cert_sn");
        certItem.setCert(cert);
        String signSourceData = this.getSignSourceData(request, responseBody);
        certItem.setSignSourceDate(signSourceData);
        return certItem;
    }

    private String getSignSourceData(AlipayRequest<?> request, String body) throws AlipayApiException {
        String rootNode = request.getApiMethodName().replace('.', '_') + "_response";
        String errorRootNode = "error_response";
        int indexOfRootNode = body.indexOf(rootNode);
        int indexOfErrorRoot = body.indexOf(errorRootNode);
        if (indexOfRootNode > 0) {
            return this.parseSignSourceData(body, rootNode, indexOfRootNode);
        }
        if (indexOfErrorRoot > 0) {
            return this.parseSignSourceData(body, errorRootNode, indexOfErrorRoot);
        }
        return null;
    }

    private String parseSignSourceData(String body, String rootNode, int indexOfRootNode) throws AlipayApiException {
        int signDataStartIndex = indexOfRootNode + rootNode.length() + 2;
        int indexOfSign = body.indexOf("\"sign\"");
        if (indexOfSign < 0) {
            return null;
        }
        SignSourceData signSourceData = AlipaySignature.extractSignContent(body, signDataStartIndex);
        if (body.lastIndexOf(rootNode) > signSourceData.getEndIndex()) {
            throw new AlipayApiException("\u68c0\u6d4b\u5230\u54cd\u5e94\u62a5\u6587\u4e2d\u6709\u91cd\u590d\u7684" + rootNode + "\uff0c\u9a8c\u7b7e\u5931\u8d25\u3002");
        }
        return signSourceData.getSourceData();
    }

    private String getSign(String body) {
        JSONValidatingReader reader = new JSONValidatingReader(new ExceptionErrorListener());
        Object rootObj = ((JSONReader)reader).read(body);
        Map rootJson = (Map)rootObj;
        return (String)rootJson.get("sign");
    }

    @Override
    public String decryptSourceData(AlipayRequest<?> request, String body, String format, Decryptor decryptor, String encryptType, String charset) throws AlipayApiException {
        ResponseParseItem respSignSourceData = this.getJSONSignSourceData(request, body);
        String bodyIndexContent = body.substring(0, respSignSourceData.getStartIndex());
        String bodyEndContent = body.substring(respSignSourceData.getEndIndex());
        return bodyIndexContent + decryptor.decrypt(respSignSourceData.getEncryptContent(), encryptType, charset) + bodyEndContent;
    }

    private ResponseParseItem getJSONSignSourceData(AlipayRequest<?> request, String body) {
        String rootNode = request.getApiMethodName().replace('.', '_') + "_response";
        String errorRootNode = "error_response";
        int indexOfRootNode = body.indexOf(rootNode);
        int indexOfErrorRoot = body.indexOf(errorRootNode);
        if (indexOfRootNode > 0) {
            return this.parseJSONSignSourceData(body, rootNode, indexOfRootNode);
        }
        if (indexOfErrorRoot > 0) {
            return this.parseJSONSignSourceData(body, errorRootNode, indexOfErrorRoot);
        }
        return null;
    }

    private ResponseParseItem parseJSONSignSourceData(String body, String rootNode, int indexOfRootNode) {
        int signDataStartIndex = indexOfRootNode + rootNode.length() + 2;
        int signDataEndIndex = JsonConverter.extractJsonBase64ValueEndPosition(body, signDataStartIndex);
        String encryptContent = body.substring(signDataStartIndex + 1, signDataEndIndex - 1);
        return new ResponseParseItem(signDataStartIndex, signDataEndIndex, encryptContent);
    }

    private static int extractJsonBase64ValueEndPosition(String responseString, int beginPosition) {
        for (int index = beginPosition; index < responseString.length(); ++index) {
            if (responseString.charAt(index) != '\"' || index == beginPosition) continue;
            return index + 1;
        }
        return responseString.length();
    }
}

