/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.kms.aliyun;

import com.alipay.easysdk.kms.aliyun.credentials.AccessKeyCredentials;
import com.alipay.easysdk.kms.aliyun.credentials.BasicSessionCredentials;
import com.alipay.easysdk.kms.aliyun.credentials.ICredentials;
import com.alipay.easysdk.kms.aliyun.credentials.provider.CredentialsProviderFactory;
import com.alipay.easysdk.kms.aliyun.credentials.provider.EcsRamRoleCredentialsProvider;
import com.alipay.easysdk.kms.aliyun.credentials.provider.ICredentialsProvider;
import com.alipay.easysdk.kms.aliyun.credentials.provider.RamRoleArnCredentialsProvider;
import com.alipay.easysdk.kms.aliyun.credentials.provider.StaticCredentialsProvider;
import com.alipay.easysdk.kms.aliyun.models.RuntimeOptions;
import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.TeaRetryableException;
import com.aliyun.tea.TeaUnretryableException;
import com.aliyun.tea.ValidateException;
import com.aliyun.tea.utils.StringUtils;
import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Base64;

public class AliyunRpcClient {
    private final String accessKeyId;
    private final String accessKeySecret;
    private final String securityToken;
    private final String roleArn;
    private final String roleName;
    private final String credentialType;
    private final String policy;
    private final String endpoint;
    private final String format;
    private final String signatureMethod;
    private final String signatureVersion;
    private final ICredentialsProvider credentialsProvider;

    public AliyunRpcClient(Map<String, Object> config) {
        this.accessKeyId = (String)config.get("aliyunAccessKeyId");
        this.accessKeySecret = (String)config.get("aliyunAccessKeySecret");
        this.securityToken = (String)config.get("aliyunSecurityToken");
        this.roleArn = (String)config.get("aliyunRoleArn");
        this.roleName = (String)config.get("aliyunRoleName");
        this.credentialType = (String)config.get("credentialType");
        this.policy = (String)config.get("aliyunRolePolicy");
        this.endpoint = (String)config.get("kmsEndpoint");
        this.format = "json";
        this.signatureMethod = "HMAC-SHA1";
        this.signatureVersion = "1.0";
        this.credentialsProvider = this.getCredentialsProvider();
    }

    public static String percentEncode(String value) throws UnsupportedEncodingException {
        return value != null ? URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
    }

    private static String getSignature(Map<String, String> signedParams, String method, String secret) throws Exception {
        Object[] sortedKeys = signedParams.keySet().toArray(new String[0]);
        Arrays.sort(sortedKeys);
        StringBuilder canonicalizedQueryString = new StringBuilder();
        for (Object key : sortedKeys) {
            if (StringUtils.isEmpty((CharSequence)signedParams.get(key))) continue;
            canonicalizedQueryString.append("&").append(AliyunRpcClient.percentEncode((String)key)).append("=").append(AliyunRpcClient.percentEncode(signedParams.get(key)));
        }
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(new SecretKeySpec((secret + "&").getBytes(StandardCharsets.UTF_8), "HmacSHA1"));
        String stringToSign = method + "&" + AliyunRpcClient.percentEncode("/") + "&" + AliyunRpcClient.percentEncode(canonicalizedQueryString.toString().substring(1));
        byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
        return Base64.toBase64String((byte[])signData);
    }

    public static Object parseJSON(String json) {
        return new Gson().fromJson(json, Map.class);
    }

    public static Map<String, Object> assertAsMap(Object object) {
        if (null != object && Map.class.isAssignableFrom(object.getClass())) {
            return (Map)object;
        }
        throw new RuntimeException("The value is not a object");
    }

    public static byte[] readAsBytes(InputStream stream) throws IOException {
        if (null == stream) {
            return new byte[0];
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        int read;
        while ((read = stream.read(buff)) != -1) {
            os.write(buff, 0, read);
        }
        return os.toByteArray();
    }

    public static String readAsString(InputStream stream) throws IOException {
        return new String(AliyunRpcClient.readAsBytes(stream), StandardCharsets.UTF_8);
    }

    public static Object readAsJSON(InputStream stream) throws IOException {
        String body = AliyunRpcClient.readAsString(stream);
        return AliyunRpcClient.parseJSON(body);
    }

    public static String getTimestamp() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(new SimpleTimeZone(0, "UTC"));
        return df.format(new Date());
    }

    public static String getNonce() {
        StringBuilder uniqueNonce = new StringBuilder();
        UUID uuid = UUID.randomUUID();
        uniqueNonce.append(uuid.toString());
        uniqueNonce.append(System.currentTimeMillis());
        uniqueNonce.append(Thread.currentThread().getId());
        return uniqueNonce.toString();
    }

    public static String toFormString(Map<String, ?> map) throws UnsupportedEncodingException {
        if (null == map) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (StringUtils.isEmpty(entry.getValue())) continue;
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(String.valueOf(entry.getValue()), "UTF-8"));
        }
        return result.toString();
    }

    public static void validateModel(TeaModel m) throws Exception {
        if (null == m) {
            throw new ValidateException("parameter is not allowed as null");
        }
        m.validate();
    }

    public static Map<String, Object> anyifyMapValue(Map<String, ?> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (null == map) {
            return null;
        }
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static boolean is4xx(Number code) {
        if (null == code) {
            return false;
        }
        return code.intValue() >= 400 && code.intValue() < 500;
    }

    public static boolean is5xx(Number code) {
        if (null == code) {
            return false;
        }
        return code.intValue() >= 500 && code.intValue() < 600;
    }

    public static boolean isUnset(Object object) {
        return null == object;
    }

    private ICredentialsProvider getCredentialsProvider() {
        CredentialsProviderFactory factory = new CredentialsProviderFactory();
        if (StringUtils.isEmpty((CharSequence)this.credentialType)) {
            return this.getAccessKeyCredentialsProvider(this.accessKeyId, this.accessKeySecret, factory);
        }
        switch (this.credentialType) {
            case "access_key": {
                return this.getAccessKeyCredentialsProvider(this.accessKeyId, this.accessKeySecret, factory);
            }
            case "sts": {
                return this.getStsTokenCredentialsProvider(this.accessKeyId, this.accessKeySecret, this.securityToken, factory);
            }
            case "ecs_ram_role": {
                return this.getEcsRamRoleCredentialsProvider(this.roleName, factory);
            }
            case "ram_role_arn": {
                return this.getRamRoleArnCredentialsProvider(this.accessKeyId, this.accessKeySecret, this.roleArn, this.policy, factory);
            }
        }
        throw new IllegalArgumentException("The credentialType is not supported");
    }

    private ICredentialsProvider getAccessKeyCredentialsProvider(String accessKeyId, String accessKeySecret, CredentialsProviderFactory factory) {
        return factory.createCredentialsProvider(new StaticCredentialsProvider(new AccessKeyCredentials(accessKeyId, accessKeySecret)));
    }

    private ICredentialsProvider getStsTokenCredentialsProvider(String accessKeyId, String accessKeySecret, String securityToken, CredentialsProviderFactory factory) {
        return factory.createCredentialsProvider(new StaticCredentialsProvider(new BasicSessionCredentials(accessKeyId, accessKeySecret, securityToken)));
    }

    private ICredentialsProvider getEcsRamRoleCredentialsProvider(String roleName, CredentialsProviderFactory factory) {
        if (StringUtils.isEmpty((CharSequence)roleName)) {
            throw new IllegalArgumentException("The roleName is empty");
        }
        return factory.createCredentialsProvider(new EcsRamRoleCredentialsProvider(roleName));
    }

    private ICredentialsProvider getRamRoleArnCredentialsProvider(String accessKeyId, String accessKeySecret, String roleArn, String policy, CredentialsProviderFactory factory) {
        if (StringUtils.isEmpty((CharSequence)accessKeyId) || StringUtils.isEmpty((CharSequence)accessKeySecret)) {
            throw new IllegalArgumentException("The accessKeyId or accessKeySecret is empty");
        }
        if (StringUtils.isEmpty((CharSequence)roleArn)) {
            throw new IllegalArgumentException("The roleArn is empty");
        }
        return factory.createCredentialsProvider(new RamRoleArnCredentialsProvider(accessKeyId, accessKeySecret, roleArn, policy));
    }

    public Map<String, Object> doRequest(String action, String protocol, String method, String version, Map<String, Object> query, Map<String, Object> body, RuntimeOptions runtime) throws Exception {
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("readTimeout", (Object)runtime.readTimeout), new TeaPair("connectTimeout", (Object)runtime.connectTimeout), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("maxAttempts", (Object)runtime.maxAttempts)})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)runtime.backoffPolicy), new TeaPair("period", (Object)runtime.backoffPeriod)})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                ICredentials credentials;
                TeaRequest request_ = new TeaRequest();
                request_.protocol = protocol;
                request_.method = method;
                request_.pathname = "/";
                request_.query = TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("Action", (Object)action), new TeaPair("Format", (Object)this.format), new TeaPair("Timestamp", (Object)AliyunRpcClient.getTimestamp()), new TeaPair("Version", (Object)version), new TeaPair("SignatureNonce", (Object)AliyunRpcClient.getNonce())}), query});
                request_.headers = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("host", (Object)this.endpoint)});
                if (!AliyunRpcClient.isUnset(body)) {
                    Map<String, Object> tmp = AliyunRpcClient.anyifyMapValue(body);
                    request_.body = Tea.toReadable((String)AliyunRpcClient.toFormString(tmp));
                    request_.headers.put("content-type", "application/x-www-form-urlencoded");
                }
                if ((credentials = this.credentialsProvider.getCredentials()) == null) {
                    throw new TeaRetryableException();
                }
                request_.query.put("SignatureMethod", this.signatureMethod);
                request_.query.put("SignatureVersion", this.signatureVersion);
                request_.query.put("AccessKeyId", credentials.getAccessKeyId());
                if (!StringUtils.isEmpty((CharSequence)credentials.getSecurityToken())) {
                    request_.query.put("SecurityToken", credentials.getSecurityToken());
                }
                Map signedParam = TeaConverter.merge(String.class, (Map[])new Map[]{request_.query, body});
                request_.query.put("Signature", AliyunRpcClient.getSignature(signedParam, request_.method, credentials.getAccessKeySecret()));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_);
                Object obj = AliyunRpcClient.readAsJSON(response_.body);
                Map<String, Object> res = AliyunRpcClient.assertAsMap(obj);
                if (AliyunRpcClient.is4xx(response_.statusCode) || AliyunRpcClient.is5xx(response_.statusCode)) {
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("message", res.get("Message")), new TeaPair("data", res), new TeaPair("code", res.get("Code"))}));
                }
                return res;
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }
}

