/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.support.AbstractValueDecoder;
import com.alicp.jetcache.support.JavaValueDecoder;
import com.alicp.jetcache.support.Kryo5ValueDecoder;
import com.alicp.jetcache.support.KryoValueDecoder;
import com.alicp.jetcache.support.SpringJavaValueDecoder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class DecoderMap {
    private final ConcurrentHashMap<Integer, AbstractValueDecoder> decoderMap = new ConcurrentHashMap();
    private volatile boolean inited = false;
    private final ReentrantLock reentrantLock = new ReentrantLock();
    private static final DecoderMap instance = new DecoderMap();

    public static DecoderMap defaultInstance() {
        return instance;
    }

    public AbstractValueDecoder getDecoder(int identityNumber) {
        return this.decoderMap.get(identityNumber);
    }

    public void register(int identityNumber, AbstractValueDecoder decoder) {
        this.decoderMap.put(identityNumber, decoder);
    }

    public void clear() {
        this.decoderMap.clear();
    }

    public ReentrantLock getLock() {
        return this.reentrantLock;
    }

    public void setInited(boolean inited) {
        this.inited = inited;
    }

    public void initDefaultDecoder() {
        if (this.inited) {
            return;
        }
        this.reentrantLock.lock();
        try {
            if (this.inited) {
                return;
            }
            this.register(1251293824, DecoderMap.defaultJavaValueDecoder());
            this.register(1251293826, KryoValueDecoder.INSTANCE);
            this.register(-153049664, Kryo5ValueDecoder.INSTANCE);
            this.inited = true;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    public static JavaValueDecoder defaultJavaValueDecoder() {
        try {
            Class.forName("org.springframework.core.ConfigurableObjectInputStream");
            return SpringJavaValueDecoder.INSTANCE;
        }
        catch (ClassNotFoundException e) {
            return JavaValueDecoder.INSTANCE;
        }
    }
}

