/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.autoconfigure;

import com.alicp.jetcache.CacheBuilder;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.anno.CacheConsts;
import com.alicp.jetcache.autoconfigure.ConfigTree;
import com.alicp.jetcache.autoconfigure.ExternalCacheAutoInit;
import com.alicp.jetcache.autoconfigure.JetCacheCondition;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.redis.lettuce.JetCacheCodec;
import com.alicp.jetcache.redis.lettuce.LettuceConnectionManager;
import com.alicp.jetcache.redis.lettuce.RedisLettuceCacheBuilder;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.masterreplica.MasterReplica;
import io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={RedisLettuceCondition.class})
public class RedisLettuceAutoConfiguration {
    public static final String AUTO_INIT_BEAN_NAME = "redisLettuceAutoInit";

    @Bean(name={"redisLettuceAutoInit"})
    public RedisLettuceAutoInit redisLettuceAutoInit() {
        return new RedisLettuceAutoInit();
    }

    public static class RedisLettuceAutoInit
    extends ExternalCacheAutoInit {
        public RedisLettuceAutoInit() {
            super("redis.lettuce");
        }

        @Override
        protected CacheBuilder initCache(ConfigTree ct, String cacheAreaWithPrefix) {
            StatefulRedisMasterReplicaConnection connection;
            RedisClient client;
            Map<String, Object> map = ct.subTree("uri").getProperties();
            String readFromStr = ct.getProperty("readFrom");
            String mode = ct.getProperty("mode");
            long asyncResultTimeoutInMillis = ct.getProperty("asyncResultTimeoutInMillis", CacheConsts.ASYNC_RESULT_TIMEOUT.toMillis());
            boolean enablePubSub = this.parseBroadcastChannel(ct) != null;
            ReadFrom readFrom = null;
            if (readFromStr != null) {
                readFrom = ReadFrom.valueOf((String)readFromStr.trim());
            }
            StatefulRedisPubSubConnection pubSubConnection = null;
            if (map == null || map.size() == 0) {
                throw new CacheConfigException("lettuce uri is required");
            }
            List uriList = map.values().stream().map(k -> RedisURI.create((URI)URI.create(k.toString()))).collect(Collectors.toList());
            if ("Cluster".equalsIgnoreCase(mode)) {
                client = RedisClusterClient.create(uriList);
                connection = this.clusterConnection(ct, readFrom, (RedisClusterClient)client, false);
                if (enablePubSub) {
                    pubSubConnection = (StatefulRedisPubSubConnection)this.clusterConnection(ct, readFrom, (RedisClusterClient)client, true);
                }
            } else {
                client = RedisClient.create();
                client.setOptions(ClientOptions.builder().disconnectedBehavior(ClientOptions.DisconnectedBehavior.REJECT_COMMANDS).build());
                StatefulRedisMasterReplicaConnection c = MasterReplica.connect((RedisClient)client, (RedisCodec)new JetCacheCodec(), uriList);
                if (readFrom != null) {
                    c.setReadFrom(readFrom);
                }
                connection = c;
                if (enablePubSub) {
                    pubSubConnection = client.connectPubSub((RedisCodec)new JetCacheCodec(), (RedisURI)uriList.get(0));
                }
            }
            ExternalCacheBuilder externalCacheBuilder = ((RedisLettuceCacheBuilder.RedisLettuceCacheBuilderImpl)((RedisLettuceCacheBuilder.RedisLettuceCacheBuilderImpl)((RedisLettuceCacheBuilder.RedisLettuceCacheBuilderImpl)RedisLettuceCacheBuilder.createRedisLettuceCacheBuilder().connection(connection)).pubSubConnection(pubSubConnection)).redisClient((AbstractRedisClient)client)).asyncResultTimeoutInMillis(asyncResultTimeoutInMillis);
            this.parseGeneralConfig((CacheBuilder)externalCacheBuilder, ct);
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".client", client);
            LettuceConnectionManager m = LettuceConnectionManager.defaultManager();
            m.init((AbstractRedisClient)client, (StatefulConnection)connection);
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".connection", m.connection((AbstractRedisClient)client));
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".commands", m.commands((AbstractRedisClient)client));
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".asyncCommands", m.asyncCommands((AbstractRedisClient)client));
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".reactiveCommands", m.reactiveCommands((AbstractRedisClient)client));
            return externalCacheBuilder;
        }

        private StatefulConnection<byte[], byte[]> clusterConnection(ConfigTree ct, ReadFrom readFrom, RedisClusterClient client, boolean pubsub) {
            int enablePeriodicRefresh = ct.getProperty("enablePeriodicRefresh", 60);
            boolean enableAllAdaptiveRefreshTriggers = ct.getProperty("enableAllAdaptiveRefreshTriggers", true);
            ClusterTopologyRefreshOptions.Builder topologyOptionBuilder = ClusterTopologyRefreshOptions.builder();
            if (enablePeriodicRefresh > 0) {
                topologyOptionBuilder.enablePeriodicRefresh(Duration.ofSeconds(enablePeriodicRefresh));
            }
            if (enableAllAdaptiveRefreshTriggers) {
                topologyOptionBuilder.enableAllAdaptiveRefreshTriggers();
            }
            ClusterClientOptions options = ClusterClientOptions.builder().topologyRefreshOptions(topologyOptionBuilder.build()).disconnectedBehavior(ClientOptions.DisconnectedBehavior.REJECT_COMMANDS).build();
            client.setOptions(options);
            if (pubsub) {
                return client.connectPubSub((RedisCodec)new JetCacheCodec());
            }
            StatefulRedisClusterConnection c = client.connect((RedisCodec)new JetCacheCodec());
            if (readFrom != null) {
                c.setReadFrom(readFrom);
            }
            return c;
        }
    }

    public static class RedisLettuceCondition
    extends JetCacheCondition {
        public RedisLettuceCondition() {
            super("redis.lettuce");
        }
    }
}

