/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.autoconfigure;

import com.alicp.jetcache.AbstractCacheBuilder;
import com.alicp.jetcache.CacheBuilder;
import com.alicp.jetcache.anno.support.ParserFunction;
import com.alicp.jetcache.autoconfigure.AutoConfigureBeans;
import com.alicp.jetcache.autoconfigure.ConfigTree;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.Assert;

public abstract class AbstractCacheAutoInit
implements InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(AbstractCacheAutoInit.class);
    @Autowired
    protected ConfigurableEnvironment environment;
    @Autowired
    protected AutoConfigureBeans autoConfigureBeans;
    private final ReentrantLock reentrantLock = new ReentrantLock();
    protected String[] typeNames;
    private volatile boolean inited = false;

    public AbstractCacheAutoInit(String ... cacheTypes) {
        Objects.requireNonNull(cacheTypes, "cacheTypes can't be null");
        Assert.isTrue((cacheTypes.length > 0 ? 1 : 0) != 0, (String)"cacheTypes length is 0");
        this.typeNames = cacheTypes;
    }

    public void afterPropertiesSet() {
        if (!this.inited) {
            this.reentrantLock.lock();
            try {
                if (!this.inited) {
                    this.process("jetcache.local.", this.autoConfigureBeans.getLocalCacheBuilders(), true);
                    this.process("jetcache.remote.", this.autoConfigureBeans.getRemoteCacheBuilders(), false);
                    this.inited = true;
                }
            }
            finally {
                this.reentrantLock.unlock();
            }
        }
    }

    private void process(String prefix, Map cacheBuilders, boolean local) {
        ConfigTree resolver = new ConfigTree(this.environment, prefix);
        Map<String, Object> m = resolver.getProperties();
        Set<String> cacheAreaNames = resolver.directChildrenKeys();
        for (String cacheArea : cacheAreaNames) {
            Object configType = m.get(cacheArea + ".type");
            boolean match = Arrays.stream(this.typeNames).anyMatch(tn -> tn.equals(configType));
            if (!match) continue;
            ConfigTree ct = resolver.subTree(cacheArea + ".");
            logger.info("init cache area {} , type= {}", (Object)cacheArea, (Object)this.typeNames[0]);
            CacheBuilder c = this.initCache(ct, local ? "local." + cacheArea : "remote." + cacheArea);
            cacheBuilders.put(cacheArea, c);
        }
    }

    protected void parseGeneralConfig(CacheBuilder builder, ConfigTree ct) {
        String expireAfterAccessInMillis;
        AbstractCacheBuilder acb = (AbstractCacheBuilder)builder;
        acb.keyConvertor((Function)new ParserFunction(ct.getProperty("keyConvertor", "FASTJSON2")));
        String expireAfterWriteInMillis = ct.getProperty("expireAfterWriteInMillis");
        if (expireAfterWriteInMillis == null) {
            expireAfterWriteInMillis = ct.getProperty("defaultExpireInMillis");
        }
        if (expireAfterWriteInMillis != null) {
            acb.setExpireAfterWriteInMillis(Long.parseLong(expireAfterWriteInMillis));
        }
        if ((expireAfterAccessInMillis = ct.getProperty("expireAfterAccessInMillis")) != null) {
            acb.setExpireAfterAccessInMillis(Long.parseLong(expireAfterAccessInMillis));
        }
    }

    protected abstract CacheBuilder initCache(ConfigTree var1, String var2);
}

