/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.alibaba.ttl.spi.TtlEnhanced;
import com.alibaba.ttl.spi.TtlWrapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class TtlWrappers {
    @Nullable
    public static <T> Supplier<T> wrapSupplier(@Nullable Supplier<T> supplier) {
        if (supplier == null) {
            return null;
        }
        if (supplier instanceof TtlEnhanced) {
            return supplier;
        }
        return new TtlSupplier<T>(supplier);
    }

    @Deprecated
    @Nullable
    public static <T> Supplier<T> wrap(@Nullable Supplier<T> supplier) {
        return TtlWrappers.wrapSupplier(supplier);
    }

    @Nullable
    public static <T> Consumer<T> wrapConsumer(@Nullable Consumer<T> consumer) {
        if (consumer == null) {
            return null;
        }
        if (consumer instanceof TtlEnhanced) {
            return consumer;
        }
        return new TtlConsumer<T>(consumer);
    }

    @Deprecated
    @Nullable
    public static <T> Consumer<T> wrap(@Nullable Consumer<T> consumer) {
        return TtlWrappers.wrapConsumer(consumer);
    }

    @Nullable
    public static <T, U> BiConsumer<T, U> wrapBiConsumer(@Nullable BiConsumer<T, U> consumer) {
        if (consumer == null) {
            return null;
        }
        if (consumer instanceof TtlEnhanced) {
            return consumer;
        }
        return new TtlBiConsumer<T, U>(consumer);
    }

    @Deprecated
    @Nullable
    public static <T, U> BiConsumer<T, U> wrap(@Nullable BiConsumer<T, U> consumer) {
        return TtlWrappers.wrapBiConsumer(consumer);
    }

    @Nullable
    public static <T, R> Function<T, R> wrapFunction(@Nullable Function<T, R> fn) {
        if (fn == null) {
            return null;
        }
        if (fn instanceof TtlEnhanced) {
            return fn;
        }
        return new TtlFunction<T, R>(fn);
    }

    @Deprecated
    @Nullable
    public static <T, R> Function<T, R> wrap(@Nullable Function<T, R> fn) {
        return TtlWrappers.wrapFunction(fn);
    }

    @Nullable
    public static <T, U, R> BiFunction<T, U, R> wrapBiFunction(@Nullable BiFunction<T, U, R> fn) {
        if (fn == null) {
            return null;
        }
        if (fn instanceof TtlEnhanced) {
            return fn;
        }
        return new TtlBiFunction<T, U, R>(fn);
    }

    @Deprecated
    @Nullable
    public static <T, U, R> BiFunction<T, U, R> wrap(@Nullable BiFunction<T, U, R> fn) {
        return TtlWrappers.wrapBiFunction(fn);
    }

    private TtlWrappers() {
        throw new InstantiationError("Must not instantiate this class");
    }

    private static class TtlBiFunction<T, U, R>
    implements BiFunction<T, U, R>,
    TtlWrapper<BiFunction<T, U, R>>,
    TtlEnhanced {
        final BiFunction<T, U, R> fn;
        final Object captured;

        TtlBiFunction(@NonNull BiFunction<T, U, R> fn) {
            this.fn = fn;
            this.captured = TransmittableThreadLocal.Transmitter.capture();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public R apply(T t, U u) {
            Object backup = TransmittableThreadLocal.Transmitter.replay(this.captured);
            try {
                R r = this.fn.apply(t, u);
                return r;
            }
            finally {
                TransmittableThreadLocal.Transmitter.restore(backup);
            }
        }

        @Override
        @NonNull
        public BiFunction<T, U, R> unwrap() {
            return this.fn;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TtlBiFunction that = (TtlBiFunction)o;
            return this.fn.equals(that.fn);
        }

        public int hashCode() {
            return this.fn.hashCode();
        }

        public String toString() {
            return this.getClass().getName() + " - " + this.fn.toString();
        }
    }

    private static class TtlFunction<T, R>
    implements Function<T, R>,
    TtlWrapper<Function<T, R>>,
    TtlEnhanced {
        final Function<T, R> fn;
        final Object captured;

        TtlFunction(@NonNull Function<T, R> fn) {
            this.fn = fn;
            this.captured = TransmittableThreadLocal.Transmitter.capture();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public R apply(T t) {
            Object backup = TransmittableThreadLocal.Transmitter.replay(this.captured);
            try {
                R r = this.fn.apply(t);
                return r;
            }
            finally {
                TransmittableThreadLocal.Transmitter.restore(backup);
            }
        }

        @Override
        @NonNull
        public Function<T, R> unwrap() {
            return this.fn;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TtlFunction that = (TtlFunction)o;
            return this.fn.equals(that.fn);
        }

        public int hashCode() {
            return this.fn.hashCode();
        }

        public String toString() {
            return this.getClass().getName() + " - " + this.fn.toString();
        }
    }

    private static class TtlBiConsumer<T, U>
    implements BiConsumer<T, U>,
    TtlWrapper<BiConsumer<T, U>>,
    TtlEnhanced {
        final BiConsumer<T, U> consumer;
        final Object captured;

        TtlBiConsumer(@NonNull BiConsumer<T, U> consumer) {
            this.consumer = consumer;
            this.captured = TransmittableThreadLocal.Transmitter.capture();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(T t, U u) {
            Object backup = TransmittableThreadLocal.Transmitter.replay(this.captured);
            try {
                this.consumer.accept(t, u);
            }
            finally {
                TransmittableThreadLocal.Transmitter.restore(backup);
            }
        }

        @Override
        @NonNull
        public BiConsumer<T, U> unwrap() {
            return this.consumer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TtlBiConsumer that = (TtlBiConsumer)o;
            return this.consumer.equals(that.consumer);
        }

        public int hashCode() {
            return this.consumer.hashCode();
        }

        public String toString() {
            return this.getClass().getName() + " - " + this.consumer.toString();
        }
    }

    private static class TtlConsumer<T>
    implements Consumer<T>,
    TtlWrapper<Consumer<T>>,
    TtlEnhanced {
        final Consumer<T> consumer;
        final Object captured;

        TtlConsumer(@NonNull Consumer<T> consumer) {
            this.consumer = consumer;
            this.captured = TransmittableThreadLocal.Transmitter.capture();
        }

        @Override
        public void accept(T t) {
            Object backup = TransmittableThreadLocal.Transmitter.replay(this.captured);
            try {
                this.consumer.accept(t);
            }
            finally {
                TransmittableThreadLocal.Transmitter.restore(backup);
            }
        }

        @Override
        @NonNull
        public Consumer<T> unwrap() {
            return this.consumer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TtlConsumer that = (TtlConsumer)o;
            return this.consumer.equals(that.consumer);
        }

        public int hashCode() {
            return this.consumer.hashCode();
        }

        public String toString() {
            return this.getClass().getName() + " - " + this.consumer.toString();
        }
    }

    private static class TtlSupplier<T>
    implements Supplier<T>,
    TtlWrapper<Supplier<T>>,
    TtlEnhanced {
        final Supplier<T> supplier;
        final Object captured;

        TtlSupplier(@NonNull Supplier<T> supplier) {
            this.supplier = supplier;
            this.captured = TransmittableThreadLocal.Transmitter.capture();
        }

        @Override
        public T get() {
            Object backup = TransmittableThreadLocal.Transmitter.replay(this.captured);
            try {
                T t = this.supplier.get();
                return t;
            }
            finally {
                TransmittableThreadLocal.Transmitter.restore(backup);
            }
        }

        @Override
        @NonNull
        public Supplier<T> unwrap() {
            return this.supplier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TtlSupplier that = (TtlSupplier)o;
            return this.supplier.equals(that.supplier);
        }

        public int hashCode() {
            return this.supplier.hashCode();
        }

        public String toString() {
            return this.getClass().getName() + " - " + this.supplier.toString();
        }
    }
}

