/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.spring.web.servlet.handler;

import com.alibaba.spring.web.method.HandlerMethodResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AnnotatedHandlerMethodHandlerInterceptorAdapter<A extends Annotation>
extends HandlerInterceptorAdapter {
    private final Class<A> annotationType = this.resolveAnnotationType();
    private final ConcurrentMap<Method, A> annotatedMethodsCache = new ConcurrentHashMap<Method, A>();

    protected AnnotatedHandlerMethodHandlerInterceptorAdapter() {
    }

    public final boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        A annotation = this.getAnnotation(handler);
        if (annotation != null) {
            return this.preHandle(request, response, (HandlerMethod)handler, annotation);
        }
        return super.preHandle(request, response, handler);
    }

    public final void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        A annotation = this.getAnnotation(handler);
        if (annotation != null) {
            this.postHandle(request, response, (HandlerMethod)handler, annotation, modelAndView);
        } else {
            super.postHandle(request, response, handler, modelAndView);
        }
    }

    public final void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        A annotation = this.getAnnotation(handler);
        if (annotation != null) {
            this.afterCompletion(request, response, (HandlerMethod)handler, annotation, ex);
        } else {
            super.afterCompletion(request, response, handler, ex);
        }
    }

    public final void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        A annotation = this.getAnnotation(handler);
        if (annotation != null) {
            this.afterConcurrentHandlingStarted(request, response, (HandlerMethod)handler, annotation);
        } else {
            super.afterConcurrentHandlingStarted(request, response, handler);
        }
    }

    protected boolean preHandle(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, A annotation) throws Exception {
        return true;
    }

    protected void postHandle(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, A annotation, ModelAndView modelAndView) throws Exception {
    }

    protected void afterCompletion(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, A annotation, Exception ex) throws Exception {
    }

    protected void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, A annotation) throws Exception {
    }

    public final Class<A> getAnnotationType() {
        return this.annotationType;
    }

    private static Collection<HandlerMethod> resolveHandlerMethods(HttpServletRequest request) {
        HandlerMethodResolver resolver = new HandlerMethodResolver();
        return resolver.resolveHandlerMethods(request);
    }

    private A getAnnotation(Object handler) {
        HandlerMethod handlerMethod;
        Method method;
        Annotation annotation = null;
        if (handler instanceof HandlerMethod && (annotation = (Annotation)this.annotatedMethodsCache.get(method = (handlerMethod = (HandlerMethod)handler).getMethod())) == null) {
            annotation = AnnotationUtils.findAnnotation((Method)method, this.annotationType);
            if (annotation == null) {
                annotation = AnnotationUtils.findAnnotation(method.getDeclaringClass(), this.annotationType);
            }
            if (annotation != null) {
                this.annotatedMethodsCache.putIfAbsent(method, annotation);
            }
        }
        return (A)annotation;
    }

    private final Class<A> resolveAnnotationType() {
        ParameterizedType parameterizedType = (ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        return (Class)actualTypeArguments[0];
    }
}

