/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.spring.web.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

public class HandlerMethodAnnotationResolver {
    private final Collection<HandlerMethod> handlerMethods;

    public HandlerMethodAnnotationResolver(Collection<HandlerMethod> handlerMethods) {
        this.handlerMethods = handlerMethods;
    }

    public <A extends Annotation> Map<Method, A> resolve(Class<A> annotationType) {
        LinkedHashMap<Method, Annotation> resolvedHandlerMethods = new LinkedHashMap<Method, Annotation>();
        for (HandlerMethod handlerMethod : this.handlerMethods) {
            Annotation annotation = handlerMethod.getMethodAnnotation(annotationType);
            if (annotation == null) {
                annotation = AnnotationUtils.findAnnotation((Class)handlerMethod.getBeanType(), annotationType);
            }
            if (annotation == null) continue;
            resolvedHandlerMethods.put(handlerMethod.getMethod(), annotation);
        }
        return Collections.unmodifiableMap(resolvedHandlerMethods);
    }
}

