/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.spring.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.AliasRegistry;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class BeanRegistrar {
    private static final Log log = LogFactory.getLog(BeanRegistrar.class);

    public static boolean registerInfrastructureBean(BeanDefinitionRegistry beanDefinitionRegistry, String beanName, Class<?> beanType) {
        boolean registered = false;
        if (!beanDefinitionRegistry.containsBeanDefinition(beanName)) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(beanType);
            beanDefinition.setRole(2);
            beanDefinitionRegistry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
            registered = true;
            if (log.isInfoEnabled()) {
                log.info((Object)("The Infrastructure bean definition [" + beanDefinition + "with name [" + beanName + "] has been registered."));
            }
        }
        return registered;
    }

    public static boolean hasAlias(AliasRegistry registry, String beanName, String alias) {
        return StringUtils.hasText((String)beanName) && StringUtils.hasText((String)alias) && ObjectUtils.containsElement((Object[])registry.getAliases(beanName), (Object)alias);
    }
}

