/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.spring.boot.health;

import com.alibaba.dubbo.rpc.service.EchoService;
import com.alibaba.dubbo.spring.boot.DubboConsumerAutoConfiguration;
import com.alibaba.dubbo.spring.boot.domain.ClassIdBean;
import com.alibaba.dubbo.spring.boot.listener.ConsumerSubscribeListener;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

public class DubboHealthIndicator
extends AbstractHealthIndicator {
    public void doHealthCheck(Health.Builder builder) throws Exception {
        boolean up = true;
        for (ClassIdBean classIdBean : ConsumerSubscribeListener.SUBSCRIBEDINTERFACES_SET) {
            Object service = DubboConsumerAutoConfiguration.getDubboReference(classIdBean);
            EchoService echoService = (EchoService)service;
            if (echoService == null) continue;
            try {
                echoService.$echo((Object)"Hello");
                builder.withDetail(classIdBean.toString(), (Object)Status.UP.getCode());
            }
            catch (Throwable t) {
                up = false;
                builder.withDetail(classIdBean.toString(), (Object)(Status.DOWN.getCode() + ", message: " + t.getMessage()));
            }
        }
        if (up) {
            builder.up();
        } else {
            builder.down();
        }
    }
}

