/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.util;

import com.alibaba.simpleimage.ImageFormat;
import com.alibaba.simpleimage.io.ByteArrayOutputStream;
import java.awt.RenderingHints;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import org.apache.commons.io.IOUtils;

public final class ImageUtils {
    private static final float FLOAT_MIN = -3.4028235E38f;

    private ImageUtils() {
    }

    public static void closeQuietly(ImageInputStream inStream) {
        if (inStream != null) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(ImageOutputStream outStream) {
        if (outStream != null) {
            try {
                outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(com.alibaba.simpleimage.io.ImageInputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(ImageReader reader) {
        if (reader != null) {
            try {
                reader.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ImageLayout getImageLayoutHint(RenderingHints renderHints) {
        if (renderHints == null) {
            return null;
        }
        return (ImageLayout)renderHints.get(JAI.KEY_IMAGE_LAYOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJPEG(InputStream source) throws IOException {
        InputStream iis = source;
        if (!source.markSupported()) {
            throw new IllegalArgumentException("Input stream must support mark");
        }
        iis.mark(30);
        try {
            int byte1 = iis.read();
            int byte2 = iis.read();
            if (byte1 == 255 && byte2 == 216) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            iis.reset();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBMP(InputStream in) throws IOException {
        if (!in.markSupported()) {
            throw new IllegalArgumentException("Input stream must support mark");
        }
        byte[] b = new byte[2];
        try {
            in.mark(30);
            in.read(b);
        }
        finally {
            in.reset();
        }
        return b[0] == 66 && b[1] == 77;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGIF(InputStream in) throws IOException {
        if (!in.markSupported()) {
            throw new IllegalArgumentException("Input stream must support mark");
        }
        byte[] b = new byte[6];
        try {
            in.mark(30);
            in.read(b);
        }
        finally {
            in.reset();
        }
        return b[0] == 71 && b[1] == 73 && b[2] == 70 && b[3] == 56 && (b[4] == 55 || b[4] == 57) && b[5] == 97;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPNG(InputStream in) throws IOException {
        if (!in.markSupported()) {
            throw new IllegalArgumentException("Input stream must support mark");
        }
        byte[] b = new byte[8];
        try {
            in.mark(30);
            in.read(b);
        }
        finally {
            in.reset();
        }
        return b[0] == -119 && b[1] == 80 && b[2] == 78 && b[3] == 71 && b[4] == 13 && b[5] == 10 && b[6] == 26 && b[7] == 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTIFF(InputStream in) throws IOException {
        if (!in.markSupported()) {
            throw new IllegalArgumentException("Input stream must support mark");
        }
        byte[] b = new byte[4];
        try {
            in.mark(30);
            in.read(b);
        }
        finally {
            in.reset();
        }
        return b[0] == 73 && b[1] == 73 && b[2] == 42 && b[3] == 0 || b[0] == 77 && b[1] == 77 && b[2] == 0 && b[3] == 42;
    }

    public static ImageFormat identifyFormat(InputStream in) throws IOException {
        if (ImageUtils.isJPEG(in)) {
            return ImageFormat.JPEG;
        }
        if (ImageUtils.isPNG(in)) {
            return ImageFormat.PNG;
        }
        if (ImageUtils.isGIF(in)) {
            return ImageFormat.GIF;
        }
        if (ImageUtils.isBMP(in)) {
            return ImageFormat.BMP;
        }
        if (ImageUtils.isTIFF(in)) {
            return ImageFormat.TIFF;
        }
        return null;
    }

    public static InputStream createMemoryStream(InputStream input) throws IOException {
        if (!(input instanceof com.alibaba.simpleimage.io.ByteArrayInputStream) && !(input instanceof ByteArrayInputStream)) {
            ByteArrayOutputStream temp = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)temp);
            input = temp.toInputStream();
            Object var1_1 = null;
        }
        return input;
    }

    public static final byte clampRoundByte(double in) {
        return in > 255.0 ? (byte)-1 : (in >= 0.0 ? (byte)(in + 0.5) : (byte)0);
    }

    public static final short clampRoundUShort(double in) {
        return in > 65535.0 ? (short)-1 : (in >= 0.0 ? (short)(in + 0.5) : (short)0);
    }

    public static final short clampRoundShort(double in) {
        return (short)(in > 32767.0 ? Short.MAX_VALUE : (in >= -32768.0 ? (int)((int)Math.floor(in + 0.5)) : Short.MIN_VALUE));
    }

    public static final int clampRoundInt(double in) {
        return in > 2.147483647E9 ? Integer.MAX_VALUE : (in >= -2.147483648E9 ? (int)Math.floor(in + 0.5) : Integer.MIN_VALUE);
    }

    public static final float clampFloat(double in) {
        return in > 3.4028234663852886E38 ? Float.MAX_VALUE : (in >= -3.4028234663852886E38 ? (float)in : -3.4028235E38f);
    }
}

