/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.render;

import com.alibaba.simpleimage.ImageRender;
import com.alibaba.simpleimage.ImageWrapper;
import com.alibaba.simpleimage.SimpleImageException;
import com.alibaba.simpleimage.render.CropParameter;
import com.alibaba.simpleimage.render.ReadRender;
import com.alibaba.simpleimage.util.ImageCropHelper;
import java.io.InputStream;
import javax.media.jai.PlanarImage;

public class CropRender
extends ImageRender {
    private CropParameter cropParameter = null;
    private ImageWrapper imgWrapper = null;

    public CropRender(ImageRender imageRender) {
        super(imageRender);
    }

    public CropRender(ImageRender imageRender, CropParameter param) {
        super(imageRender);
        this.cropParameter = param;
    }

    public CropRender(ImageWrapper imgWrapper, CropParameter param) {
        super(null);
        this.imgWrapper = imgWrapper;
        this.cropParameter = param;
    }

    public CropRender(InputStream input, CropParameter param) {
        super(new ReadRender(input));
        this.cropParameter = param;
    }

    public void dispose() throws SimpleImageException {
        super.dispose();
        this.cropParameter = null;
    }

    public ImageWrapper render() throws SimpleImageException {
        if (this.cropParameter == null) {
            if (this.imgWrapper == null) {
                return this.imageRender.render();
            }
            return this.imgWrapper;
        }
        if (this.imgWrapper == null) {
            this.imgWrapper = this.imageRender.render();
        }
        for (int i = 0; i < this.imgWrapper.getNumOfImages(); ++i) {
            PlanarImage pi = ImageCropHelper.crop(this.imgWrapper.getAsPlanarImage(i), this.cropParameter);
            this.imgWrapper.setImage(i, pi);
        }
        return this.imgWrapper;
    }

    public CropParameter getCropParameter() {
        return this.cropParameter;
    }

    public void setCropParameter(CropParameter cropParameter) {
        this.cropParameter = cropParameter;
    }
}

