/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.analyze.search.tree;

import com.alibaba.simpleimage.analyze.search.cluster.ClusterBuilder;
import com.alibaba.simpleimage.analyze.search.cluster.Clusterable;
import com.alibaba.simpleimage.analyze.search.cluster.impl.Cluster;
import com.alibaba.simpleimage.analyze.search.tree.KMeansTreeNode;
import com.alibaba.simpleimage.analyze.search.tree.VocabularyTree;
import com.alibaba.simpleimage.analyze.search.util.TreeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMeansTree
implements VocabularyTree,
Serializable {
    private static final long serialVersionUID = 1L;
    public static int idCount = 0;
    private int branchFactor = 10;
    private int maxHeight = 6;
    private int treeHeight = 0;
    private int numWords = 0;
    private KMeansTreeNode rootNode;

    public KMeansTree(List<Clusterable> items, int branchFactor, int height, ClusterBuilder clusterer) {
        this.branchFactor = branchFactor;
        this.maxHeight = height;
        this.rootNode = new KMeansTreeNode(Cluster.getMeanValue(items), items, this.branchFactor, this.maxHeight, 0, clusterer);
    }

    public int getBranchFactor() {
        return this.branchFactor;
    }

    public int getNumWords() {
        return this.numWords;
    }

    public List<KMeansTreeNode> getBreadthWiseList() {
        ArrayList<KMeansTreeNode> nodes = new ArrayList<KMeansTreeNode>(this.rootNode.getNumSubItems() + 1);
        LinkedList<KMeansTreeNode> nodesLeft = new LinkedList<KMeansTreeNode>();
        nodesLeft.add(this.rootNode);
        KMeansTreeNode node = (KMeansTreeNode)nodesLeft.remove(0);
        while (node != null) {
            nodes.add(node);
            if (!node.isLeafNode()) {
                nodesLeft.addAll(node.getSubNodes());
            }
            if (nodesLeft.size() > 0) {
                node = (KMeansTreeNode)nodesLeft.remove(0);
                continue;
            }
            node = null;
        }
        return nodes;
    }

    public List<KMeansTreeNode> getLeafsList() {
        ArrayList<KMeansTreeNode> nodes = new ArrayList<KMeansTreeNode>(this.rootNode.getNumSubItems() + 1);
        LinkedList<KMeansTreeNode> nodesLeft = new LinkedList<KMeansTreeNode>();
        nodesLeft.add(this.rootNode);
        KMeansTreeNode node = (KMeansTreeNode)nodesLeft.remove(0);
        while (node != null) {
            if (node.isLeafNode()) {
                nodes.add(node);
            } else {
                nodesLeft.addAll(node.getSubNodes());
            }
            if (nodesLeft.size() > 0) {
                node = (KMeansTreeNode)nodesLeft.remove(0);
                continue;
            }
            node = null;
        }
        return nodes;
    }

    @Override
    public List<Integer> addImage(List<? extends Clusterable> imagePoints) {
        ArrayList<Integer> visual_word_list = new ArrayList<Integer>();
        for (Clusterable clusterable : imagePoints) {
            visual_word_list.add(this.addPoint(clusterable));
        }
        return visual_word_list;
    }

    public int addPoint(Clusterable point) {
        ++this.numWords;
        return this.rootNode.addValue(point);
    }

    @Override
    public List<Float> getCurrentWords() {
        return TreeUtils.getCurrentWord(this.rootNode, this.rootNode.getNumSubItems());
    }

    @Override
    public void reset() {
        this.numWords = 0;
        this.rootNode.reset();
    }

    public int getTreeHeight() {
        return this.treeHeight;
    }

    public KMeansTreeNode getRootNode() {
        return this.rootNode;
    }
}

