/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.analyze.search.cluster.impl;

import com.alibaba.simpleimage.analyze.search.cluster.ClusterBuilder;
import com.alibaba.simpleimage.analyze.search.cluster.ClusterChecker;
import com.alibaba.simpleimage.analyze.search.cluster.Clusterable;
import com.alibaba.simpleimage.analyze.search.cluster.impl.Cluster;
import com.alibaba.simpleimage.analyze.search.cluster.impl.DriftClusterChecker;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClusterBuilder
implements ClusterBuilder {
    public static float DISTANCE_TOLERANCE = 0.005f;
    public static int MAX_RECLUSTERING = 100;
    int mMaxReclustering = MAX_RECLUSTERING;
    ClusterChecker mChecker;

    protected AbstractClusterBuilder() {
        this(new DriftClusterChecker(DISTANCE_TOLERANCE), MAX_RECLUSTERING);
    }

    protected AbstractClusterBuilder(ClusterChecker checker) {
        this(checker, MAX_RECLUSTERING);
    }

    protected AbstractClusterBuilder(ClusterChecker checker, int maxReclustering) {
        this.mChecker = checker;
        this.mMaxReclustering = maxReclustering;
    }

    @Override
    public Clusterable[] collect(List<? extends Clusterable> values, int numClusters) {
        Clusterable[] clusters = this.calculateInitialClusters(values, numClusters);
        boolean recalculateClusters = true;
        int numIterations = 0;
        while (recalculateClusters) {
            recalculateClusters = this.mChecker.recalculateClusters(clusters = this.assignClusters(clusters, values));
            if (!recalculateClusters) continue;
            if (numIterations > this.mMaxReclustering) {
                recalculateClusters = false;
            }
            clusters = this.getNewClusters(clusters);
            ++numIterations;
        }
        return clusters;
    }

    protected abstract Clusterable[] assignClusters(Clusterable[] var1, List<? extends Clusterable> var2);

    protected abstract Clusterable[] getNewClusters(Clusterable[] var1);

    protected Cluster[] calculateInitialClusters(List<? extends Clusterable> values, int numClusters) {
        Cluster[] clusters = new Cluster[numClusters];
        Random random = new Random(1L);
        HashSet<Integer> clusterCenters = new HashSet<Integer>();
        for (int i = 0; i < numClusters; ++i) {
            int index = random.nextInt(values.size());
            while (clusterCenters.contains(index)) {
                index = random.nextInt(values.size());
            }
            clusterCenters.add(index);
            clusters[i] = new Cluster(values.get(index).getLocation(), i);
        }
        return clusters;
    }
}

