/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.oop;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import org.jaxen.JaxenException;

public class StringConcatRule
extends AbstractAliRule {
    private static final String XPATH = "Statement/Block//Expression[preceding-sibling::AssignmentOperator]/AdditiveExpression[(@Image = '+') and count(./PrimaryExpression/PrimaryPrefix/Literal[@StringLiteral = 'true']) > 0]";

    public Object visit(ASTForStatement node, Object data) {
        this.checkStringConcat((Node)node, data, ASTForStatement.class);
        return super.visit(node, data);
    }

    public Object visit(ASTWhileStatement node, Object data) {
        this.checkStringConcat((Node)node, data, ASTWhileStatement.class);
        return super.visit(node, data);
    }

    public Object visit(ASTDoStatement node, Object data) {
        this.checkStringConcat((Node)node, data, ASTDoStatement.class);
        return super.visit(node, data);
    }

    private void checkStringConcat(Node node, Object data, Class nodeClass) {
        try {
            List additiveNodes = node.findChildNodesWithXPath(XPATH);
            block2: for (Node additiveNode : additiveNodes) {
                List nodes;
                ASTAdditiveExpression additiveExpression = (ASTAdditiveExpression)additiveNode;
                Node assignmentStatement = additiveExpression.getNthParent(2);
                if (!(assignmentStatement instanceof ASTStatementExpression) || (nodes = ((ASTStatementExpression)assignmentStatement).findChildNodesWithXPath("PrimaryExpression/PrimaryPrefix/Name[@Image]")) == null || nodes.size() != 1) continue;
                NameDeclaration resultVar = ((ASTName)nodes.get(0)).getNameDeclaration();
                if (resultVar != null && resultVar.getNode() != null) {
                    boolean isDefinedInLoop = false;
                    for (AbstractJavaNode loopStatement = (AbstractJavaNode)resultVar.getNode().getFirstParentOfType(nodeClass); loopStatement != null; loopStatement = (AbstractJavaNode)loopStatement.getFirstParentOfType(nodeClass)) {
                        if (loopStatement != node) continue;
                        isDefinedInLoop = true;
                        break;
                    }
                    if (isDefinedInLoop) {
                        return;
                    }
                }
                for (int i = 0; i < additiveNode.jjtGetNumChildren(); ++i) {
                    NameDeclaration firstArgVar;
                    List names;
                    Node firstArg = additiveNode.jjtGetChild(i);
                    if (!(firstArg instanceof ASTPrimaryExpression) || (names = ((ASTPrimaryExpression)firstArg).findChildNodesWithXPath("./PrimaryPrefix/Name[@Image]")) == null || names.size() != 1 || resultVar != (firstArgVar = ((ASTName)names.get(0)).getNameDeclaration())) continue;
                    this.addViolation(data, additiveNode);
                    continue block2;
                }
            }
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
    }

    public void addViolation(Object data, Node node, String arg) {
        ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, node, data, I18nResources.getMessage("java.oop.PojoMustOverrideToStringRule.violation.msg"));
    }
}

