/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.flowcontrol;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;

public class SwitchStatementRule
extends AbstractAliRule {
    private static final String MESSAGE_KEY_PREFIX = "java.flowcontrol.SwitchStatementRule.violation";

    public Object visit(ASTSwitchStatement node, Object data) {
        this.checkDefault(node, data);
        this.checkFallThrough(node, data);
        return super.visit(node, data);
    }

    private void checkDefault(ASTSwitchStatement node, Object data) {
        String switchCheckXpath = "SwitchLabel[@Default = 'true']";
        if (!node.hasDescendantMatchingXPath("SwitchLabel[@Default = 'true']")) {
            this.addViolationWithMessage(data, (Node)node, "java.flowcontrol.SwitchStatementRule.violation.nodefault");
        }
    }

    private void checkFallThrough(ASTSwitchStatement node, Object data) {
        String xpath = "../SwitchStatement[(count(.//BreakStatement) + count(BlockStatement//Statement/ReturnStatement) + count(BlockStatement//Statement/ContinueStatement) + count(BlockStatement//Statement/ThrowStatement) + count(BlockStatement//Statement/IfStatement[@Else='true' and Statement[2][ReturnStatement|ContinueStatement|ThrowStatement]]/Statement[1][ReturnStatement|ContinueStatement|ThrowStatement]) + count(SwitchLabel[name(following-sibling::node()) = 'SwitchLabel']) + count(SwitchLabel[count(following-sibling::node()) = 0])  < count (SwitchLabel[@Default != 'true']) + count(SwitchLabel[@Default = 'true']/following-sibling::BlockStatement//Statement/ReturnStatement) + count(SwitchLabel[@Default = 'true']/following-sibling::BlockStatement//Statement/ContinueStatement) + count(SwitchLabel[@Default = 'true']/following-sibling::BlockStatement//Statement/ThrowStatement))]";
        if (node.hasDescendantMatchingXPath("../SwitchStatement[(count(.//BreakStatement) + count(BlockStatement//Statement/ReturnStatement) + count(BlockStatement//Statement/ContinueStatement) + count(BlockStatement//Statement/ThrowStatement) + count(BlockStatement//Statement/IfStatement[@Else='true' and Statement[2][ReturnStatement|ContinueStatement|ThrowStatement]]/Statement[1][ReturnStatement|ContinueStatement|ThrowStatement]) + count(SwitchLabel[name(following-sibling::node()) = 'SwitchLabel']) + count(SwitchLabel[count(following-sibling::node()) = 0])  < count (SwitchLabel[@Default != 'true']) + count(SwitchLabel[@Default = 'true']/following-sibling::BlockStatement//Statement/ReturnStatement) + count(SwitchLabel[@Default = 'true']/following-sibling::BlockStatement//Statement/ContinueStatement) + count(SwitchLabel[@Default = 'true']/following-sibling::BlockStatement//Statement/ThrowStatement))]")) {
            this.addViolationWithMessage(data, (Node)node, "java.flowcontrol.SwitchStatementRule.violation.notermination");
        }
    }
}

