/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.comment;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.comment.AbstractAliCommentRule;
import com.alibaba.p3c.pmd.lang.java.rule.util.NodeSortUtils;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;

public class EnumConstantsMustHaveCommentRule
extends AbstractAliCommentRule {
    public Object visit(ASTCompilationUnit cUnit, Object data) {
        SortedMap<Integer, Node> itemsByLineNumber = this.orderedCommentsAndEnumDeclarations(cUnit);
        boolean isPreviousEnumDecl = false;
        for (Map.Entry<Integer, Node> entry : itemsByLineNumber.entrySet()) {
            Node value = entry.getValue();
            if (value instanceof ASTEnumDeclaration) {
                isPreviousEnumDecl = true;
                continue;
            }
            if (value instanceof ASTEnumConstant && isPreviousEnumDecl) {
                Node enumBody = value.jjtGetParent();
                Node enumDeclaration = enumBody.jjtGetParent();
                this.addViolationWithMessage(data, enumBody, I18nResources.getMessage("java.comment.EnumConstantsMustHaveCommentRule.violation.msg", enumDeclaration.getImage()));
                isPreviousEnumDecl = false;
                continue;
            }
            isPreviousEnumDecl = false;
        }
        return super.visit(cUnit, data);
    }

    private SortedMap<Integer, Node> orderedCommentsAndEnumDeclarations(ASTCompilationUnit cUnit) {
        TreeMap<Integer, Node> itemsByLineNumber = new TreeMap<Integer, Node>();
        List enumDecl = cUnit.findDescendantsOfType(ASTEnumDeclaration.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, enumDecl);
        List contantDecl = cUnit.findDescendantsOfType(ASTEnumConstant.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, contantDecl);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, cUnit.getComments());
        return itemsByLineNumber;
    }
}

