/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.set;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.util.namelist.NameListConfig;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import org.jaxen.JaxenException;

public class CollectionInitShouldAssignCapacityRule
extends AbstractAliRule {
    private static final List<String> COLLECTION_LIST = NameListConfig.NAME_LIST_SERVICE.getNameList(CollectionInitShouldAssignCapacityRule.class.getSimpleName(), "COLLECTION_TYPE");

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        try {
            for (String collectionType : COLLECTION_LIST) {
                this.visitByCollections(node, data, collectionType);
            }
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
        return super.visit(node, data);
    }

    private void visitByCollections(ASTClassOrInterfaceDeclaration node, Object data, String collectionType) throws JaxenException {
        String collectionArgXpath = "//AllocationExpression/ClassOrInterfaceType[@Image='" + collectionType + "']/../Arguments";
        List argumentsNodes = node.findChildNodesWithXPath(collectionArgXpath);
        for (Node argNode : argumentsNodes) {
            ASTArguments argumentNode;
            Integer count;
            if (!(argNode instanceof ASTArguments) || argNode.getFirstParentOfType(ASTMethodDeclaration.class) == null || (count = Integer.valueOf((argumentNode = (ASTArguments)argNode).getArgumentCount())) != 0) continue;
            this.addViolationWithMessage(data, argNode, "java.set.CollectionInitShouldAssignCapacityRule.violation.msg", new Object[]{collectionType});
        }
    }
}

