/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.index;

import com.alibaba.otter.canal.common.utils.JsonUtils;
import com.alibaba.otter.canal.meta.exception.CanalMetaManagerException;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.index.AbstractLogPositionManager;
import com.alibaba.otter.canal.parse.index.MemoryLogPositionManager;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import com.google.common.collect.MigrateMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMixedLogPositionManager
extends AbstractLogPositionManager {
    private static final Logger logger = LoggerFactory.getLogger(FileMixedLogPositionManager.class);
    private static final Charset charset = Charset.forName("UTF-8");
    private File dataDir;
    private Map<String, File> dataFileCaches;
    private ScheduledExecutorService executorService;
    private final LogPosition nullPosition = new LogPosition(){};
    private MemoryLogPositionManager memoryLogPositionManager;
    private long period;
    private Set<String> persistTasks;

    public FileMixedLogPositionManager(File dataDir, long period, MemoryLogPositionManager memoryLogPositionManager) {
        if (dataDir == null) {
            throw new NullPointerException("null dataDir");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("period must be positive, given: " + period);
        }
        if (memoryLogPositionManager == null) {
            throw new NullPointerException("null memoryLogPositionManager");
        }
        this.dataDir = dataDir;
        this.period = period;
        this.memoryLogPositionManager = memoryLogPositionManager;
        this.dataFileCaches = MigrateMap.makeComputingMap(this::getDataFile);
        this.executorService = Executors.newScheduledThreadPool(1);
        this.persistTasks = Collections.synchronizedSet(new HashSet());
    }

    public void start() {
        super.start();
        if (!this.dataDir.exists()) {
            try {
                FileUtils.forceMkdir((File)this.dataDir);
            }
            catch (IOException e) {
                throw new CanalMetaManagerException((Throwable)e);
            }
        }
        if (!this.dataDir.canRead() || !this.dataDir.canWrite()) {
            throw new CanalMetaManagerException("dir[" + this.dataDir.getPath() + "] can not read/write");
        }
        if (!this.memoryLogPositionManager.isStart()) {
            this.memoryLogPositionManager.start();
        }
        this.executorService.scheduleAtFixedRate(() -> {
            ArrayList<String> tasks = new ArrayList<String>(this.persistTasks);
            for (String destination : tasks) {
                try {
                    this.flushDataToFile(destination);
                    this.persistTasks.remove(destination);
                }
                catch (Throwable e) {
                    logger.error("period update" + destination + " curosr failed!", e);
                }
            }
        }, this.period, this.period, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        super.stop();
        this.flushDataToFile();
        this.executorService.shutdown();
        this.memoryLogPositionManager.stop();
    }

    @Override
    public LogPosition getLatestIndexBy(String destination) {
        LogPosition logPosition = this.memoryLogPositionManager.getLatestIndexBy(destination);
        if (logPosition != null) {
            return logPosition;
        }
        logPosition = this.loadDataFromFile(this.dataFileCaches.get(destination));
        if (logPosition == null) {
            return this.nullPosition;
        }
        return logPosition;
    }

    @Override
    public void persistLogPosition(String destination, LogPosition logPosition) throws CanalParseException {
        this.persistTasks.add(destination);
        this.memoryLogPositionManager.persistLogPosition(destination, logPosition);
    }

    private File getDataFile(String destination) {
        File destinationMetaDir = new File(this.dataDir, destination);
        if (!destinationMetaDir.exists()) {
            try {
                FileUtils.forceMkdir((File)destinationMetaDir);
            }
            catch (IOException e) {
                throw new CanalMetaManagerException((Throwable)e);
            }
        }
        String dataFileName = "parse.dat";
        return new File(destinationMetaDir, dataFileName);
    }

    private void flushDataToFile() {
        for (String destination : this.memoryLogPositionManager.destinations()) {
            this.flushDataToFile(destination);
        }
    }

    private void flushDataToFile(String destination) {
        this.flushDataToFile(destination, this.dataFileCaches.get(destination));
    }

    private void flushDataToFile(String destination, File dataFile) {
        LogPosition position = this.memoryLogPositionManager.getLatestIndexBy(destination);
        if (position != null && position != this.nullPosition) {
            String json = JsonUtils.marshalToString((Object)position);
            try {
                FileUtils.writeStringToFile((File)dataFile, (String)json);
            }
            catch (IOException e) {
                throw new CanalMetaManagerException((Throwable)e);
            }
        }
    }

    private LogPosition loadDataFromFile(File dataFile) {
        try {
            if (!dataFile.exists()) {
                return null;
            }
            String json = FileUtils.readFileToString((File)dataFile, (String)charset.name());
            return (LogPosition)JsonUtils.unmarshalFromString((String)json, LogPosition.class);
        }
        catch (IOException e) {
            throw new CanalMetaManagerException((Throwable)e);
        }
    }
}

