/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.ha;

import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.parse.CanalHASwitchable;
import com.alibaba.otter.canal.parse.ha.CanalHAController;
import com.alibaba.otter.canal.parse.inbound.HeartBeatCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeatHAController
extends AbstractCanalLifeCycle
implements CanalHAController,
HeartBeatCallback {
    private static final Logger logger = LoggerFactory.getLogger(HeartBeatHAController.class);
    private int detectingRetryTimes = 3;
    private int failedTimes = 0;
    private boolean switchEnable = false;
    private CanalHASwitchable eventParser;

    @Override
    public void onSuccess(long costTime) {
        this.failedTimes = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailed(Throwable e) {
        ++this.failedTimes;
        HeartBeatHAController heartBeatHAController = this;
        synchronized (heartBeatHAController) {
            if (this.failedTimes > this.detectingRetryTimes) {
                if (this.switchEnable) {
                    this.eventParser.doSwitch();
                    this.failedTimes = 0;
                } else {
                    logger.warn("HeartBeat failed Times:{} , should auto switch ?", (Object)this.failedTimes);
                }
            }
        }
    }

    public void setCanalHASwitchable(CanalHASwitchable canalHASwitchable) {
        this.eventParser = canalHASwitchable;
    }

    public void setDetectingRetryTimes(int detectingRetryTimes) {
        this.detectingRetryTimes = detectingRetryTimes;
    }

    public void setSwitchEnable(boolean switchEnable) {
        this.switchEnable = switchEnable;
    }
}

