/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql.packets.server;

import com.alibaba.otter.canal.parse.driver.mysql.packets.HeaderPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.PacketWithHeaderPacket;
import com.alibaba.otter.canal.parse.driver.mysql.utils.ByteHelper;
import java.io.IOException;

public class HandshakeInitializationPacket
extends PacketWithHeaderPacket {
    public byte protocolVersion = (byte)10;
    public String serverVersion;
    public long threadId;
    public byte[] seed;
    public int serverCapabilities;
    public byte serverCharsetNumber;
    public int serverStatus;
    public byte[] restOfScrambleBuff;
    public byte[] authPluginName;

    public HandshakeInitializationPacket() {
    }

    public HandshakeInitializationPacket(HeaderPacket header) {
        super(header);
    }

    @Override
    public void fromBytes(byte[] data) {
        int index = 0;
        this.protocolVersion = data[index];
        byte[] serverVersionBytes = ByteHelper.readNullTerminatedBytes(data, ++index);
        this.serverVersion = new String(serverVersionBytes);
        this.threadId = ByteHelper.readUnsignedIntLittleEndian(data, index += serverVersionBytes.length + 1);
        this.seed = ByteHelper.readFixedLengthBytes(data, index += 4, 8);
        index += 8;
        this.serverCapabilities = ByteHelper.readUnsignedShortLittleEndian(data, ++index);
        if (data.length > (index += 2)) {
            this.serverCharsetNumber = data[index];
            this.serverStatus = ByteHelper.readUnsignedShortLittleEndian(data, ++index);
            int capabilityFlags2 = ByteHelper.readUnsignedShortLittleEndian(data, index += 2);
            index += 2;
            int capabilities = capabilityFlags2 << 16 | this.serverCapabilities;
            ++index;
            index += 10;
            if ((capabilities & 0x8000) != 0) {
                this.restOfScrambleBuff = ByteHelper.readFixedLengthBytes(data, index, 12);
            }
            index += 13;
            if ((capabilities & 0x80000) != 0) {
                this.authPluginName = ByteHelper.readNullTerminatedBytes(data, index);
            }
        }
    }

    @Override
    public byte[] toBytes() throws IOException {
        return null;
    }
}

