/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.dbsync.binlog.event;

import com.taobao.tddl.dbsync.binlog.LogBuffer;
import com.taobao.tddl.dbsync.binlog.LogEvent;
import com.taobao.tddl.dbsync.binlog.event.FormatDescriptionLogEvent;
import com.taobao.tddl.dbsync.binlog.event.LogHeader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public final class TableMapLogEvent
extends LogEvent {
    protected String dbname;
    protected String tblname;
    protected final int columnCnt;
    protected final ColumnInfo[] columnInfo;
    protected final long tableId;
    protected BitSet nullBits;
    public static final int TM_MAPID_OFFSET = 0;
    public static final int TM_FLAGS_OFFSET = 6;
    public static final int SIGNEDNESS = 1;
    public static final int DEFAULT_CHARSET = 2;
    public static final int COLUMN_CHARSET = 3;
    public static final int COLUMN_NAME = 4;
    public static final int SET_STR_VALUE = 5;
    public static final int ENUM_STR_VALUE = 6;
    public static final int GEOMETRY_TYPE = 7;
    public static final int SIMPLE_PRIMARY_KEY = 8;
    public static final int PRIMARY_KEY_WITH_PREFIX = 9;
    private int default_charset;
    private boolean existOptionalMetaData = false;

    public TableMapLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) {
        super(header);
        int commonHeaderLen = descriptionEvent.commonHeaderLen;
        short postHeaderLen = descriptionEvent.postHeaderLen[header.type - 1];
        buffer.position(commonHeaderLen + 0);
        this.tableId = postHeaderLen == 6 ? buffer.getUint32() : buffer.getUlong48();
        buffer.position(commonHeaderLen + postHeaderLen);
        this.dbname = buffer.getString();
        buffer.forward(1);
        this.tblname = buffer.getString();
        buffer.forward(1);
        this.columnCnt = (int)buffer.getPackedLong();
        this.columnInfo = new ColumnInfo[this.columnCnt];
        for (int i = 0; i < this.columnCnt; ++i) {
            ColumnInfo info = new ColumnInfo();
            info.type = buffer.getUint8();
            this.columnInfo[i] = info;
        }
        if (buffer.position() < buffer.limit()) {
            int fieldSize = (int)buffer.getPackedLong();
            this.decodeFields(buffer, fieldSize);
            this.nullBits = buffer.getBitmap(this.columnCnt);
            for (int i = 0; i < this.columnCnt; ++i) {
                if (!this.nullBits.get(i)) continue;
                this.columnInfo[i].nullable = true;
            }
            this.existOptionalMetaData = false;
            List<Pair> defaultCharsetPairs = null;
            List<Integer> columnCharsets = null;
            block13: while (buffer.hasRemaining()) {
                int type = buffer.getUint8();
                int len = (int)buffer.getPackedLong();
                switch (type) {
                    case 1: {
                        this.parse_signedness(buffer, len);
                        continue block13;
                    }
                    case 2: {
                        defaultCharsetPairs = this.parse_default_charset(buffer, len);
                        continue block13;
                    }
                    case 3: {
                        columnCharsets = this.parse_column_charset(buffer, len);
                        continue block13;
                    }
                    case 4: {
                        this.existOptionalMetaData = true;
                        this.parse_column_name(buffer, len);
                        continue block13;
                    }
                    case 5: {
                        this.parse_set_str_value(buffer, len, true);
                        continue block13;
                    }
                    case 6: {
                        this.parse_set_str_value(buffer, len, false);
                        continue block13;
                    }
                    case 7: {
                        this.parse_geometry_type(buffer, len);
                        continue block13;
                    }
                    case 8: {
                        this.parse_simple_pk(buffer, len);
                        continue block13;
                    }
                    case 9: {
                        this.parse_pk_with_prefix(buffer, len);
                        continue block13;
                    }
                }
                throw new IllegalArgumentException("unknow type : " + type);
            }
            if (this.existOptionalMetaData) {
                int index = 0;
                int char_col_index = 0;
                for (int i = 0; i < this.columnCnt; ++i) {
                    int cs = -1;
                    int type = this.getRealType(this.columnInfo[i].type, this.columnInfo[i].meta);
                    if (!this.is_character_type(type)) continue;
                    if (defaultCharsetPairs != null && !defaultCharsetPairs.isEmpty()) {
                        if (index < defaultCharsetPairs.size() && char_col_index == defaultCharsetPairs.get((int)index).col_index) {
                            cs = defaultCharsetPairs.get((int)index).col_charset;
                            ++index;
                        } else {
                            cs = this.default_charset;
                        }
                        ++char_col_index;
                    } else if (columnCharsets != null) {
                        cs = columnCharsets.get(index);
                        ++index;
                    }
                    this.columnInfo[i].charset = cs;
                }
            }
        }
    }

    private final void decodeFields(LogBuffer buffer, int len) {
        int limit = buffer.limit();
        buffer.limit(len + buffer.position());
        block9: for (int i = 0; i < this.columnCnt; ++i) {
            ColumnInfo info = this.columnInfo[i];
            switch (info.type) {
                case 4: 
                case 5: 
                case 245: 
                case 249: 
                case 250: 
                case 251: 
                case 252: 
                case 255: {
                    info.meta = buffer.getUint8();
                    continue block9;
                }
                case 247: 
                case 248: {
                    logger.warn((Object)("This enumeration value is only used internally and cannot exist in a binlog: type=" + info.type));
                    continue block9;
                }
                case 254: {
                    int x = buffer.getUint8() << 8;
                    info.meta = x += buffer.getUint8();
                    continue block9;
                }
                case 16: {
                    info.meta = buffer.getUint16();
                    continue block9;
                }
                case 15: {
                    info.meta = buffer.getUint16();
                    continue block9;
                }
                case 246: {
                    int x = buffer.getUint8() << 8;
                    info.meta = x += buffer.getUint8();
                    continue block9;
                }
                case 17: 
                case 18: 
                case 19: {
                    info.meta = buffer.getUint8();
                    continue block9;
                }
                default: {
                    info.meta = 0;
                }
            }
        }
        buffer.limit(limit);
    }

    private void parse_signedness(LogBuffer buffer, int length) {
        ArrayList<Boolean> datas = new ArrayList<Boolean>();
        for (int i = 0; i < length; ++i) {
            int ut = buffer.getUint8();
            for (int c = 128; c != 0; c >>= 1) {
                datas.add((ut & c) > 0);
            }
        }
        int index = 0;
        for (int i = 0; i < this.columnCnt; ++i) {
            if (!this.is_numeric_type(this.columnInfo[i].type)) continue;
            this.columnInfo[i].unsigned = (Boolean)datas.get(index);
            ++index;
        }
    }

    private List<Pair> parse_default_charset(LogBuffer buffer, int length) {
        int limit = buffer.position() + length;
        this.default_charset = (int)buffer.getPackedLong();
        ArrayList<Pair> datas = new ArrayList<Pair>();
        while (buffer.hasRemaining() && buffer.position() < limit) {
            int col_index = (int)buffer.getPackedLong();
            int col_charset = (int)buffer.getPackedLong();
            Pair pair = new Pair();
            pair.col_index = col_index;
            pair.col_charset = col_charset;
            datas.add(pair);
        }
        return datas;
    }

    private List<Integer> parse_column_charset(LogBuffer buffer, int length) {
        int limit = buffer.position() + length;
        ArrayList<Integer> datas = new ArrayList<Integer>();
        while (buffer.hasRemaining() && buffer.position() < limit) {
            int col_charset = (int)buffer.getPackedLong();
            datas.add(col_charset);
        }
        return datas;
    }

    private void parse_column_name(LogBuffer buffer, int length) {
        int limit = buffer.position() + length;
        int index = 0;
        while (buffer.hasRemaining() && buffer.position() < limit) {
            int len = (int)buffer.getPackedLong();
            this.columnInfo[index++].name = buffer.getFixString(len);
        }
    }

    private void parse_set_str_value(LogBuffer buffer, int length, boolean set) {
        int limit = buffer.position() + length;
        ArrayList datas = new ArrayList();
        while (buffer.hasRemaining() && buffer.position() < limit) {
            int count = (int)buffer.getPackedLong();
            ArrayList<String> data = new ArrayList<String>(count);
            for (int i = 0; i < count; ++i) {
                int len1 = (int)buffer.getPackedLong();
                data.add(buffer.getFixString(len1));
            }
            datas.add(data);
        }
        int index = 0;
        for (int i = 0; i < this.columnCnt; ++i) {
            if (set && this.getRealType(this.columnInfo[i].type, this.columnInfo[i].meta) == 248) {
                this.columnInfo[i].set_enum_values = (List)datas.get(index);
                ++index;
            }
            if (set || this.getRealType(this.columnInfo[i].type, this.columnInfo[i].meta) != 247) continue;
            this.columnInfo[i].set_enum_values = (List)datas.get(index);
            ++index;
        }
    }

    private void parse_geometry_type(LogBuffer buffer, int length) {
        int limit = buffer.position() + length;
        ArrayList<Integer> datas = new ArrayList<Integer>();
        while (buffer.hasRemaining() && buffer.position() < limit) {
            int col_type = (int)buffer.getPackedLong();
            datas.add(col_type);
        }
        int index = 0;
        for (int i = 0; i < this.columnCnt; ++i) {
            if (this.columnInfo[i].type != 255) continue;
            this.columnInfo[i].geoType = (Integer)datas.get(index);
            ++index;
        }
    }

    private void parse_simple_pk(LogBuffer buffer, int length) {
        int limit = buffer.position() + length;
        while (buffer.hasRemaining() && buffer.position() < limit) {
            int col_index = (int)buffer.getPackedLong();
            this.columnInfo[col_index].pk = true;
        }
    }

    private void parse_pk_with_prefix(LogBuffer buffer, int length) {
        int limit = buffer.position() + length;
        while (buffer.hasRemaining() && buffer.position() < limit) {
            int col_index = (int)buffer.getPackedLong();
            int col_prefix = (int)buffer.getPackedLong();
            this.columnInfo[col_index].pk = true;
        }
    }

    private boolean is_numeric_type(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 246: {
                return true;
            }
        }
        return false;
    }

    private boolean is_character_type(int type) {
        switch (type) {
            case 15: 
            case 252: 
            case 253: 
            case 254: {
                return true;
            }
        }
        return false;
    }

    private int getRealType(int type, int meta) {
        if (type == 254 && meta >= 256) {
            int byte0 = meta >> 8;
            if ((byte0 & 0x30) != 48) {
                type = byte0 | 0x30;
            } else {
                switch (byte0) {
                    case 247: 
                    case 248: 
                    case 254: {
                        type = byte0;
                    }
                }
            }
        }
        return type;
    }

    public final String getDbName() {
        return this.dbname;
    }

    public final String getTableName() {
        return this.tblname;
    }

    public String getDbname() {
        return this.dbname;
    }

    public void setDbname(String dbname) {
        this.dbname = dbname;
    }

    public String getTblname() {
        return this.tblname;
    }

    public void setTblname(String tblname) {
        this.tblname = tblname;
    }

    public final int getColumnCnt() {
        return this.columnCnt;
    }

    public final ColumnInfo[] getColumnInfo() {
        return this.columnInfo;
    }

    public final long getTableId() {
        return this.tableId;
    }

    public boolean isExistOptionalMetaData() {
        return this.existOptionalMetaData;
    }

    public void setExistOptionalMetaData(boolean existOptional) {
        this.existOptionalMetaData = existOptional;
    }

    private static final class Pair {
        public int col_index;
        public int col_charset;

        private Pair() {
        }
    }

    public static final class ColumnInfo {
        public int type;
        public int meta;
        public String name;
        public boolean unsigned;
        public boolean pk;
        public List<String> set_enum_values;
        public int charset;
        public int geoType;
        public boolean nullable;

        public String toString() {
            return "ColumnInfo [type=" + this.type + ", meta=" + this.meta + ", name=" + this.name + ", unsigned=" + this.unsigned + ", pk=" + this.pk + ", set_enum_values=" + this.set_enum_values + ", charset=" + this.charset + ", geoType=" + this.geoType + ", nullable=" + this.nullable + "]";
        }
    }
}

