/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.meta;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.common.utils.JsonUtils;
import com.alibaba.otter.canal.common.zookeeper.ZkClientx;
import com.alibaba.otter.canal.common.zookeeper.ZookeeperPathUtils;
import com.alibaba.otter.canal.meta.CanalMetaManager;
import com.alibaba.otter.canal.meta.exception.CanalMetaManagerException;
import com.alibaba.otter.canal.protocol.ClientIdentity;
import com.alibaba.otter.canal.protocol.position.Position;
import com.alibaba.otter.canal.protocol.position.PositionRange;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ZooKeeperMetaManager
extends AbstractCanalLifeCycle
implements CanalMetaManager {
    private static final String ENCODE = "UTF-8";
    private ZkClientx zkClientx;

    public void start() {
        super.start();
        Assert.notNull((Object)this.zkClientx);
    }

    public void stop() {
        this.zkClientx = null;
        super.stop();
    }

    @Override
    public void subscribe(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        String path = ZookeeperPathUtils.getClientIdNodePath((String)clientIdentity.getDestination(), (short)clientIdentity.getClientId());
        try {
            this.zkClientx.createPersistent(path, true);
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            // empty catch block
        }
        if (clientIdentity.hasFilter().booleanValue()) {
            String filterPath = ZookeeperPathUtils.getFilterPath((String)clientIdentity.getDestination(), (short)clientIdentity.getClientId());
            byte[] bytes = null;
            try {
                bytes = clientIdentity.getFilter().getBytes(ENCODE);
            }
            catch (UnsupportedEncodingException e) {
                throw new CanalMetaManagerException(e);
            }
            try {
                this.zkClientx.createPersistent(filterPath, (Object)bytes);
            }
            catch (ZkNodeExistsException e) {
                this.zkClientx.writeData(filterPath, (Object)bytes);
            }
        }
    }

    @Override
    public boolean hasSubscribe(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        String path = ZookeeperPathUtils.getClientIdNodePath((String)clientIdentity.getDestination(), (short)clientIdentity.getClientId());
        return this.zkClientx.exists(path);
    }

    @Override
    public void unsubscribe(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        String path = ZookeeperPathUtils.getClientIdNodePath((String)clientIdentity.getDestination(), (short)clientIdentity.getClientId());
        this.zkClientx.deleteRecursive(path);
    }

    @Override
    public List<ClientIdentity> listAllSubscribeInfo(String destination) throws CanalMetaManagerException {
        if (this.zkClientx == null) {
            return new ArrayList<ClientIdentity>();
        }
        String path = ZookeeperPathUtils.getDestinationPath((String)destination);
        List childs = null;
        try {
            childs = this.zkClientx.getChildren(path);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            // empty catch block
        }
        if (CollectionUtils.isEmpty(childs)) {
            return new ArrayList<ClientIdentity>();
        }
        ArrayList<Short> clientIds = new ArrayList<Short>();
        for (String child : childs) {
            if (!StringUtils.isNumeric((String)child)) continue;
            clientIds.add(ZookeeperPathUtils.getClientId((String)child));
        }
        Collections.sort(clientIds);
        ArrayList clientIdentities = Lists.newArrayList();
        for (Short clientId : clientIds) {
            path = ZookeeperPathUtils.getFilterPath((String)destination, (short)clientId);
            byte[] bytes = (byte[])this.zkClientx.readData(path, true);
            String filter = null;
            if (bytes != null) {
                try {
                    filter = new String(bytes, ENCODE);
                }
                catch (UnsupportedEncodingException e) {
                    throw new CanalMetaManagerException(e);
                }
            }
            clientIdentities.add(new ClientIdentity(destination, clientId.shortValue(), filter));
        }
        return clientIdentities;
    }

    @Override
    public Position getCursor(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        String path = ZookeeperPathUtils.getCursorPath((String)clientIdentity.getDestination(), (short)clientIdentity.getClientId());
        byte[] data = (byte[])this.zkClientx.readData(path, true);
        if (data == null || data.length == 0) {
            return null;
        }
        return (Position)JsonUtils.unmarshalFromByte((byte[])data, Position.class);
    }

    @Override
    public void updateCursor(ClientIdentity clientIdentity, Position position) throws CanalMetaManagerException {
        String path = ZookeeperPathUtils.getCursorPath((String)clientIdentity.getDestination(), (short)clientIdentity.getClientId());
        byte[] data = JsonUtils.marshalToByte((Object)position, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName});
        try {
            this.zkClientx.writeData(path, (Object)data);
        }
        catch (ZkNoNodeException e) {
            this.zkClientx.createPersistent(path, (Object)data, true);
        }
    }

    @Override
    public Long addBatch(ClientIdentity clientIdentity, PositionRange positionRange) throws CanalMetaManagerException {
        String path = ZookeeperPathUtils.getBatchMarkPath((String)clientIdentity.getDestination(), (short)clientIdentity.getClientId());
        byte[] data = JsonUtils.marshalToByte((Object)positionRange, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName});
        String batchPath = this.zkClientx.createPersistentSequential(path + "/", (Object)data, true);
        String batchIdString = StringUtils.substringAfterLast((String)batchPath, (String)"/");
        return ZookeeperPathUtils.getBatchMarkId((String)batchIdString);
    }

    @Override
    public void addBatch(ClientIdentity clientIdentity, PositionRange positionRange, Long batchId) throws CanalMetaManagerException {
        String path = ZookeeperPathUtils.getBatchMarkWithIdPath((String)clientIdentity.getDestination(), (short)clientIdentity.getClientId(), (Long)batchId);
        byte[] data = JsonUtils.marshalToByte((Object)positionRange, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName});
        this.zkClientx.createPersistent(path, (Object)data, true);
    }

    @Override
    public PositionRange removeBatch(ClientIdentity clientIdentity, Long batchId) throws CanalMetaManagerException {
        String batchsPath = ZookeeperPathUtils.getBatchMarkPath((String)clientIdentity.getDestination(), (short)clientIdentity.getClientId());
        List nodes = this.zkClientx.getChildren(batchsPath);
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            return null;
        }
        ArrayList<Long> batchIds = new ArrayList<Long>(nodes.size());
        for (String batchIdString : nodes) {
            batchIds.add(Long.valueOf(batchIdString));
        }
        Long minBatchId = (Long)Collections.min(batchIds);
        if (!minBatchId.equals(batchId)) {
            throw new CanalMetaManagerException(String.format("batchId:%d is not the firstly:%d", batchId, minBatchId));
        }
        if (!batchIds.contains(batchId)) {
            return null;
        }
        PositionRange positionRange = this.getBatch(clientIdentity, batchId);
        if (positionRange != null) {
            String path = ZookeeperPathUtils.getBatchMarkWithIdPath((String)clientIdentity.getDestination(), (short)clientIdentity.getClientId(), (Long)batchId);
            this.zkClientx.delete(path);
        }
        return positionRange;
    }

    @Override
    public PositionRange getBatch(ClientIdentity clientIdentity, Long batchId) throws CanalMetaManagerException {
        String path = ZookeeperPathUtils.getBatchMarkWithIdPath((String)clientIdentity.getDestination(), (short)clientIdentity.getClientId(), (Long)batchId);
        byte[] data = (byte[])this.zkClientx.readData(path, true);
        if (data == null) {
            return null;
        }
        PositionRange positionRange = (PositionRange)JsonUtils.unmarshalFromByte((byte[])data, PositionRange.class);
        return positionRange;
    }

    @Override
    public void clearAllBatchs(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        String path = ZookeeperPathUtils.getBatchMarkPath((String)clientIdentity.getDestination(), (short)clientIdentity.getClientId());
        List batchChilds = this.zkClientx.getChildren(path);
        for (String batchChild : batchChilds) {
            String batchPath = path + "/" + batchChild;
            this.zkClientx.delete(batchPath);
        }
    }

    @Override
    public PositionRange getLastestBatch(ClientIdentity clientIdentity) {
        String path = ZookeeperPathUtils.getBatchMarkPath((String)clientIdentity.getDestination(), (short)clientIdentity.getClientId());
        List nodes = null;
        try {
            nodes = this.zkClientx.getChildren(path);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            // empty catch block
        }
        if (CollectionUtils.isEmpty(nodes)) {
            return null;
        }
        ArrayList<Long> batchIds = new ArrayList<Long>(nodes.size());
        for (String batchIdString : nodes) {
            batchIds.add(Long.valueOf(batchIdString));
        }
        Long maxBatchId = (Long)Collections.max(batchIds);
        PositionRange result = this.getBatch(clientIdentity, maxBatchId);
        if (result == null) {
            return this.getLastestBatch(clientIdentity);
        }
        return result;
    }

    @Override
    public PositionRange getFirstBatch(ClientIdentity clientIdentity) {
        String path = ZookeeperPathUtils.getBatchMarkPath((String)clientIdentity.getDestination(), (short)clientIdentity.getClientId());
        List nodes = null;
        try {
            nodes = this.zkClientx.getChildren(path);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            // empty catch block
        }
        if (CollectionUtils.isEmpty(nodes)) {
            return null;
        }
        ArrayList<Long> batchIds = new ArrayList<Long>(nodes.size());
        for (String batchIdString : nodes) {
            batchIds.add(Long.valueOf(batchIdString));
        }
        Long minBatchId = (Long)Collections.min(batchIds);
        PositionRange result = this.getBatch(clientIdentity, minBatchId);
        if (result == null) {
            return this.getFirstBatch(clientIdentity);
        }
        return result;
    }

    @Override
    public Map<Long, PositionRange> listAllBatchs(ClientIdentity clientIdentity) {
        String path = ZookeeperPathUtils.getBatchMarkPath((String)clientIdentity.getDestination(), (short)clientIdentity.getClientId());
        List nodes = null;
        try {
            nodes = this.zkClientx.getChildren(path);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            // empty catch block
        }
        if (CollectionUtils.isEmpty(nodes)) {
            return Maps.newHashMap();
        }
        ArrayList<Long> batchIds = new ArrayList<Long>(nodes.size());
        for (String batchIdString : nodes) {
            batchIds.add(Long.valueOf(batchIdString));
        }
        Collections.sort(batchIds);
        LinkedHashMap positionRanges = Maps.newLinkedHashMap();
        for (Long batchId : batchIds) {
            PositionRange result = this.getBatch(clientIdentity, batchId);
            if (result == null) {
                return this.listAllBatchs(clientIdentity);
            }
            positionRanges.put(batchId, result);
        }
        return positionRanges;
    }

    public void setZkClientx(ZkClientx zkClientx) {
        this.zkClientx = zkClientx;
    }
}

