/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.enums.mysql;

import java.util.HashMap;
import java.util.Map;

public enum TrustedMysqlFunctionEnum {
    NOW("NOW()", "NOW(3)");

    private static final Map<String, TrustedMysqlFunctionEnum> LOOKUP_MAP;
    private final String functionName;
    private final String function;

    private TrustedMysqlFunctionEnum(String functionName, String function) {
        this.functionName = functionName;
        this.function = function;
    }

    public static String getFunctionByName(String functionName) {
        TrustedMysqlFunctionEnum entry = LOOKUP_MAP.get(functionName);
        if (entry != null) {
            return entry.function;
        }
        throw new IllegalArgumentException(String.format("Invalid function name: %s", functionName));
    }

    static {
        LOOKUP_MAP = new HashMap<String, TrustedMysqlFunctionEnum>();
        for (TrustedMysqlFunctionEnum entry : TrustedMysqlFunctionEnum.values()) {
            LOOKUP_MAP.put(entry.functionName, entry);
        }
    }
}

