/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.mapper;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.datasource.mapper.Mapper;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

public interface ConfigInfoMapper
extends Mapper {
    public static final String DATA_ID = "dataId";
    public static final String GROUP = "group";
    public static final String APP_NAME = "appName";
    public static final String CONTENT = "content";
    public static final String TENANT = "tenant";

    default public String findConfigMaxId() {
        return "SELECT MAX(id) FROM config_info";
    }

    default public String findAllDataIdAndGroup() {
        return "SELECT DISTINCT data_id, group_id FROM config_info";
    }

    default public String findConfigInfoByAppCountRows() {
        return "SELECT count(*) FROM config_info WHERE tenant_id LIKE ? AND app_name = ?";
    }

    public String findConfigInfoByAppFetchRows(int var1, int var2);

    default public String configInfoLikeTenantCount() {
        return "SELECT count(*) FROM config_info WHERE tenant_id LIKE ?";
    }

    public String getTenantIdList(int var1, int var2);

    public String getGroupIdList(int var1, int var2);

    public String findAllConfigKey(int var1, int var2);

    public String findAllConfigInfoBaseFetchRows(int var1, int var2);

    public String findAllConfigInfoFragment(int var1, int var2);

    default public String findChangeConfig() {
        return "SELECT data_id, group_id, tenant_id, app_name, content, gmt_modified, encrypted_data_key FROM config_info WHERE gmt_modified >= ? AND gmt_modified <= ?";
    }

    default public String findChangeConfigCountRows(Map<String, String> params, Timestamp startTime, Timestamp endTime) {
        String tenant = params.get(TENANT);
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String appName = params.get(APP_NAME);
        String sqlCountRows = "SELECT count(*) FROM config_info WHERE ";
        String where = " 1=1 ";
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " AND data_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " AND group_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)tenant)) {
            where = where + " AND tenant_id = ? ";
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where = where + " AND app_name = ? ";
        }
        if (startTime != null) {
            where = where + " AND gmt_modified >=? ";
        }
        if (endTime != null) {
            where = where + " AND gmt_modified <=? ";
        }
        return "SELECT count(*) FROM config_info WHERE " + where;
    }

    public String findChangeConfigFetchRows(Map<String, String> var1, Timestamp var2, Timestamp var3, int var4, int var5, long var6);

    public String listGroupKeyMd5ByPageFetchRows(int var1, int var2);

    default public String findAllConfigInfo4Export(List<Long> ids, Map<String, String> params) {
        String sql = "SELECT id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_create,gmt_modified,src_user,src_ip,c_desc,c_use,effect,c_schema,encrypted_data_key FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        if (!CollectionUtils.isEmpty(ids)) {
            where.append(" id IN (");
            for (int i = 0; i < ids.size(); ++i) {
                if (i != 0) {
                    where.append(", ");
                }
                where.append('?');
            }
            where.append(") ");
        } else {
            where.append(" tenant_id = ? ");
            if (StringUtils.isNotBlank((String)params.get(DATA_ID))) {
                where.append(" AND data_id LIKE ? ");
            }
            if (StringUtils.isNotBlank((String)params.get(GROUP))) {
                where.append(" AND group_id= ? ");
            }
            if (StringUtils.isNotBlank((String)params.get(APP_NAME))) {
                where.append(" AND app_name= ? ");
            }
        }
        return sql + where;
    }

    default public String findConfigInfoBaseLikeCountRows(Map<String, String> params) {
        String sqlCountRows = "SELECT count(*) FROM config_info WHERE ";
        String where = " 1=1 AND tenant_id='" + NamespaceUtil.getNamespaceDefaultId() + "' ";
        if (!StringUtils.isBlank((CharSequence)params.get(DATA_ID))) {
            where = where + " AND data_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)params.get(GROUP))) {
            where = where + " AND group_id LIKE ? ";
        }
        if (!StringUtils.isBlank((CharSequence)params.get(CONTENT))) {
            where = where + " AND content LIKE ? ";
        }
        return "SELECT count(*) FROM config_info WHERE " + where;
    }

    public String findConfigInfoBaseLikeFetchRows(Map<String, String> var1, int var2, int var3);

    default public String findConfigInfo4PageCountRows(Map<String, String> params) {
        String appName = params.get(APP_NAME);
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String content = params.get(CONTENT);
        String sqlCount = "SELECT count(*) FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id=? ");
        if (StringUtils.isNotBlank((String)dataId)) {
            where.append(" AND data_id=? ");
        }
        if (StringUtils.isNotBlank((String)group)) {
            where.append(" AND group_id=? ");
        }
        if (StringUtils.isNotBlank((String)appName)) {
            where.append(" AND app_name=? ");
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where.append(" AND content LIKE ? ");
        }
        return "SELECT count(*) FROM config_info" + where;
    }

    public String findConfigInfo4PageFetchRows(Map<String, String> var1, int var2, int var3);

    public String findConfigInfoBaseByGroupFetchRows(int var1, int var2);

    default public String findConfigInfoLike4PageCountRows(Map<String, String> params) {
        String appName = params.get(APP_NAME);
        String content = params.get(CONTENT);
        String dataId = params.get(DATA_ID);
        String group = params.get(GROUP);
        String sqlCountRows = "SELECT count(*) FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id LIKE ? ");
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where.append(" AND data_id LIKE ? ");
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where.append(" AND group_id LIKE ? ");
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where.append(" AND app_name = ? ");
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where.append(" AND content LIKE ? ");
        }
        return "SELECT count(*) FROM config_info" + where;
    }

    public String findConfigInfoLike4PageFetchRows(Map<String, String> var1, int var2, int var3);

    public String findAllConfigInfoFetchRows(int var1, int var2);

    default public String findConfigInfosByIds(int idSize) {
        StringBuilder sql = new StringBuilder("SELECT id,data_id,group_id,tenant_id,app_name,content,md5 FROM config_info WHERE ");
        sql.append("id IN (");
        for (int i = 0; i < idSize; ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append('?');
        }
        sql.append(") ");
        return sql.toString();
    }

    default public String removeConfigInfoByIdsAtomic(int size) {
        StringBuilder sql = new StringBuilder("DELETE FROM config_info WHERE ");
        sql.append("id IN (");
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append('?');
        }
        sql.append(") ");
        return sql.toString();
    }

    default public String updateConfigInfoAtomicCas() {
        return "UPDATE config_info SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?, app_name=?,c_desc=?,c_use=?,effect=?,type=?,c_schema=? WHERE data_id=? AND group_id=? AND tenant_id=? AND (md5=? OR md5 IS NULL OR md5='')";
    }

    @Override
    default public String getTableName() {
        return "config_info";
    }
}

