/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http;

import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.HttpClientFactory;
import com.alibaba.nacos.common.http.client.NacosAsyncRestTemplate;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.client.request.DefaultAsyncHttpClientRequest;
import com.alibaba.nacos.common.http.client.request.JdkHttpClientRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.slf4j.Logger;

public abstract class AbstractHttpClientFactory
implements HttpClientFactory {
    @Override
    public final NacosRestTemplate createNacosRestTemplate() {
        HttpClientConfig httpClientConfig = this.buildHttpClientConfig();
        return new NacosRestTemplate(this.assignLogger(), new JdkHttpClientRequest(httpClientConfig));
    }

    @Override
    public final NacosAsyncRestTemplate createNacosAsyncRestTemplate() {
        RequestConfig requestConfig = this.getRequestConfig();
        return new NacosAsyncRestTemplate(this.assignLogger(), new DefaultAsyncHttpClientRequest(HttpAsyncClients.custom().setDefaultRequestConfig(requestConfig).build()));
    }

    private RequestConfig getRequestConfig() {
        HttpClientConfig httpClientConfig = this.buildHttpClientConfig();
        return RequestConfig.custom().setConnectTimeout(httpClientConfig.getConTimeOutMillis()).setSocketTimeout(httpClientConfig.getReadTimeOutMillis()).setMaxRedirects(httpClientConfig.getMaxRedirects()).build();
    }

    protected abstract HttpClientConfig buildHttpClientConfig();

    protected abstract Logger assignLogger();
}

