/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import java.util.regex.Pattern;

public class InetAddressValidator {
    private static final String PERCENT = "%";
    private static final String DOUBLE_COLON = "::";
    private static final String DOUBLE_COLON_FFFF = "::ffff:";
    private static final String FE80 = "fe80:";
    private static final int ZERO = 0;
    private static final int SEVEN = 7;
    private static final int FIVE = 5;
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
    private static final Pattern IPV6_MIXED_COMPRESSED_REGEX = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}:(?:[0-9A-Fa-f]{1,4}:)*)?)$");
    private static final Pattern IPV6_MIXED_UNCOMPRESSED_REGEX = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){6}$");

    private InetAddressValidator() {
    }

    public static boolean isIpv4Address(String input) {
        return IPV4_PATTERN.matcher(input).matches();
    }

    public static boolean isIpv6StdAddress(String input) {
        return IPV6_STD_PATTERN.matcher(input).matches();
    }

    public static boolean isIpv6HexCompressedAddress(String input) {
        return IPV6_HEX_COMPRESSED_PATTERN.matcher(input).matches();
    }

    public static boolean isIpv6Address(String input) {
        return InetAddressValidator.isIpv6StdAddress(input) || InetAddressValidator.isIpv6HexCompressedAddress(input) || InetAddressValidator.isLinkLocalIpv6WithZoneIndex(input) || InetAddressValidator.isIpv6Ipv4MappedAddress(input) || InetAddressValidator.isIpv6MixedAddress(input);
    }

    public static boolean isIpv6MixedAddress(String input) {
        int splitIndex = input.lastIndexOf(58);
        if (splitIndex == -1) {
            return false;
        }
        boolean ipv4PartValid = InetAddressValidator.isIpv4Address(input.substring(splitIndex + 1));
        String ipV6Part = input.substring(0, splitIndex + 1);
        if (DOUBLE_COLON.equals(ipV6Part)) {
            return ipv4PartValid;
        }
        boolean ipV6UncompressedDetected = IPV6_MIXED_UNCOMPRESSED_REGEX.matcher(ipV6Part).matches();
        boolean ipV6CompressedDetected = IPV6_MIXED_COMPRESSED_REGEX.matcher(ipV6Part).matches();
        return ipv4PartValid && (ipV6UncompressedDetected || ipV6CompressedDetected);
    }

    public static boolean isIpv6Ipv4MappedAddress(String input) {
        if (input.length() > 7 && input.substring(0, 7).equalsIgnoreCase(DOUBLE_COLON_FFFF)) {
            String lowerPart = input.substring(7);
            return InetAddressValidator.isIpv4Address(lowerPart);
        }
        return false;
    }

    public static boolean isLinkLocalIpv6WithZoneIndex(String input) {
        int lastIndex;
        if (input.length() > 5 && input.substring(0, 5).equalsIgnoreCase(FE80) && (lastIndex = input.lastIndexOf(PERCENT)) > 0 && lastIndex < input.length() - 1) {
            String ipPart = input.substring(0, lastIndex);
            return InetAddressValidator.isIpv6StdAddress(ipPart) || InetAddressValidator.isIpv6HexCompressedAddress(ipPart);
        }
        return false;
    }
}

