/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http;

import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.HttpClientFactory;
import com.alibaba.nacos.common.http.client.NacosAsyncRestTemplate;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.client.request.DefaultAsyncHttpClientRequest;
import com.alibaba.nacos.common.http.client.request.JdkHttpClientRequest;
import com.alibaba.nacos.common.tls.SelfHostnameVerifier;
import com.alibaba.nacos.common.tls.TlsFileWatcher;
import com.alibaba.nacos.common.tls.TlsHelper;
import com.alibaba.nacos.common.tls.TlsSystemConfig;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.RequestContent;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;

public abstract class AbstractHttpClientFactory
implements HttpClientFactory {
    private static final String ASYNC_THREAD_NAME = "nacos-http-async-client";
    private static final String ASYNC_IO_REACTOR_NAME = "nacos-http-async-client#I/O Reactor";

    @Override
    public NacosRestTemplate createNacosRestTemplate() {
        HttpClientConfig httpClientConfig = this.buildHttpClientConfig();
        JdkHttpClientRequest clientRequest = new JdkHttpClientRequest(httpClientConfig);
        this.initTls((sslContext, hostnameVerifier) -> {
            clientRequest.setSslContext(this.loadSslContext());
            clientRequest.replaceSslHostnameVerifier((HostnameVerifier)hostnameVerifier);
        }, filePath -> clientRequest.setSslContext(this.loadSslContext()));
        return new NacosRestTemplate(this.assignLogger(), clientRequest);
    }

    @Override
    public NacosAsyncRestTemplate createNacosAsyncRestTemplate() {
        IOReactorConfig ioReactorConfig = this.getIoReactorConfig();
        HttpClientConfig originalRequestConfig = this.buildHttpClientConfig();
        DefaultConnectingIOReactor ioreactor = this.getIoReactor(ASYNC_IO_REACTOR_NAME);
        RequestConfig defaultConfig = this.getRequestConfig();
        AsyncClientConnectionManager connectionManager = this.getConnectionManager(originalRequestConfig);
        this.monitorAndExtension(connectionManager);
        return new NacosAsyncRestTemplate(this.assignLogger(), new DefaultAsyncHttpClientRequest(HttpAsyncClients.custom().addRequestInterceptorLast((HttpRequestInterceptor)new RequestContent(true)).setThreadFactory((ThreadFactory)new NameThreadFactory(ASYNC_THREAD_NAME)).setIOReactorConfig(ioReactorConfig).setIoReactorExceptionCallback(ex -> {}).setDefaultRequestConfig(defaultConfig).setUserAgent(originalRequestConfig.getUserAgent()).setConnectionManager(connectionManager).build(), ioreactor, defaultConfig));
    }

    private DefaultConnectingIOReactor getIoReactor(String threadName) {
        return new DefaultConnectingIOReactor((session, ojb) -> new IOEventHandler(){

            public void connected(IOSession ioSession) throws IOException {
            }

            public void inputReady(IOSession ioSession, ByteBuffer byteBuffer) throws IOException {
            }

            public void outputReady(IOSession ioSession) throws IOException {
            }

            public void timeout(IOSession ioSession, Timeout timeout) throws IOException {
            }

            public void exception(IOSession ioSession, Exception e) {
            }

            public void disconnected(IOSession ioSession) {
            }
        }, this.getIoReactorConfig(), (ThreadFactory)new NameThreadFactory(threadName), null, ex -> {
            if (ex instanceof IOException) {
                this.assignLogger().warn("[AsyncClientConnectionManager] handle IOException, ignore it.", (Throwable)ex);
            } else if (ex instanceof RuntimeException) {
                this.assignLogger().warn("[AsyncClientConnectionManager] handle RuntimeException, ignore it.", (Throwable)ex);
            } else {
                this.assignLogger().error("[DefaultConnectingIOReactor] Exception! I/O Reactor error time: {}", (Object)System.currentTimeMillis(), (Object)ex.getCause());
            }
        }, null, null);
    }

    private AsyncClientConnectionManager getConnectionManager(HttpClientConfig originalRequestConfig) {
        try {
            SSLContext sslcontext = SSLContext.getDefault();
            DefaultHostnameVerifier hostnameVerifier = new DefaultHostnameVerifier();
            DefaultClientTlsStrategy sslStrategy = new DefaultClientTlsStrategy(sslcontext, (HostnameVerifier)hostnameVerifier);
            return PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy((TlsStrategy)sslStrategy).setMaxConnTotal(originalRequestConfig.getMaxConnTotal()).setMaxConnPerRoute(originalRequestConfig.getMaxConnPerRoute()).build();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected IOReactorConfig getIoReactorConfig() {
        HttpClientConfig httpClientConfig = this.buildHttpClientConfig();
        return IOReactorConfig.custom().setIoThreadCount(httpClientConfig.getIoThreadCount()).build();
    }

    protected RequestConfig getRequestConfig() {
        HttpClientConfig httpClientConfig = this.buildHttpClientConfig();
        return RequestConfig.custom().setConnectTimeout((long)httpClientConfig.getConTimeOutMillis(), TimeUnit.MILLISECONDS).setResponseTimeout((long)httpClientConfig.getReadTimeOutMillis(), TimeUnit.MILLISECONDS).setConnectionRequestTimeout((long)httpClientConfig.getConnectionRequestTimeout(), TimeUnit.MILLISECONDS).setContentCompressionEnabled(httpClientConfig.getContentCompressionEnabled()).setMaxRedirects(httpClientConfig.getMaxRedirects()).build();
    }

    protected void initTls(BiConsumer<SSLContext, HostnameVerifier> initTlsBiFunc, TlsFileWatcher.FileChangeListener tlsChangeListener) {
        if (!TlsSystemConfig.tlsEnable) {
            return;
        }
        HostnameVerifier hv = HttpsURLConnection.getDefaultHostnameVerifier();
        SelfHostnameVerifier selfHostnameVerifier = new SelfHostnameVerifier(hv);
        initTlsBiFunc.accept(this.loadSslContext(), selfHostnameVerifier);
        if (tlsChangeListener != null) {
            try {
                TlsFileWatcher.getInstance().addFileChangeListener(tlsChangeListener, TlsSystemConfig.tlsClientTrustCertPath, TlsSystemConfig.tlsClientKeyPath);
            }
            catch (IOException e) {
                this.assignLogger().error("add tls file listener fail", (Throwable)e);
            }
        }
    }

    protected synchronized SSLContext loadSslContext() {
        try {
            return TlsHelper.buildSslContext(true);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            this.assignLogger().error("Failed to create SSLContext", (Throwable)e);
            return null;
        }
    }

    protected abstract HttpClientConfig buildHttpClientConfig();

    protected abstract Logger assignLogger();

    protected void monitorAndExtension(AsyncClientConnectionManager connectionManager) {
    }
}

