/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.remote.http;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.http.AbstractHttpClientFactory;
import com.alibaba.nacos.common.http.HttpClientBeanHolder;
import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.HttpClientFactory;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import org.slf4j.Logger;

public class NamingHttpClientManager
implements Closeable {
    private static final int READ_TIME_OUT_MILLIS = Integer.getInteger("com.alibaba.nacos.client.naming.rtimeout", 50000);
    private static final int CON_TIME_OUT_MILLIS = Integer.getInteger("com.alibaba.nacos.client.naming.ctimeout", 3000);
    private static final boolean ENABLE_HTTPS = Boolean.getBoolean("tls.enable");
    private static final int MAX_REDIRECTS = 5;
    private static final HttpClientFactory HTTP_CLIENT_FACTORY = new NamingHttpClientFactory();

    public static NamingHttpClientManager getInstance() {
        return NamingHttpClientManagerInstance.INSTANCE;
    }

    public String getPrefix() {
        return ENABLE_HTTPS ? "https://" : "http://";
    }

    public NacosRestTemplate getNacosRestTemplate() {
        return HttpClientBeanHolder.getNacosRestTemplate(HTTP_CLIENT_FACTORY);
    }

    @Override
    public void shutdown() throws NacosException {
        LogUtils.NAMING_LOGGER.info("[NamingHttpClientManager] Start destroying NacosRestTemplate");
        try {
            HttpClientBeanHolder.shutdownNacosSyncRest(HTTP_CLIENT_FACTORY.getClass().getName());
        }
        catch (Exception ex) {
            LogUtils.NAMING_LOGGER.error("[NamingHttpClientManager] An exception occurred when the HTTP client was closed : {}", (Object)ExceptionUtil.getStackTrace(ex));
        }
        LogUtils.NAMING_LOGGER.info("[NamingHttpClientManager] Completed destruction of NacosRestTemplate");
    }

    private static class NamingHttpClientManagerInstance {
        private static final NamingHttpClientManager INSTANCE = new NamingHttpClientManager();

        private NamingHttpClientManagerInstance() {
        }
    }

    private static class NamingHttpClientFactory
    extends AbstractHttpClientFactory {
        private NamingHttpClientFactory() {
        }

        @Override
        protected HttpClientConfig buildHttpClientConfig() {
            return HttpClientConfig.builder().setConTimeOutMillis(CON_TIME_OUT_MILLIS).setReadTimeOutMillis(READ_TIME_OUT_MILLIS).setMaxRedirects(5).build();
        }

        @Override
        protected Logger assignLogger() {
            return LogUtils.NAMING_LOGGER;
        }
    }
}

