/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.lock.remote.grpc;

import com.alibaba.nacos.api.ability.constant.AbilityKey;
import com.alibaba.nacos.api.ability.constant.AbilityStatus;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.api.lock.model.LockInstance;
import com.alibaba.nacos.api.lock.remote.AbstractLockRequest;
import com.alibaba.nacos.api.lock.remote.LockOperationEnum;
import com.alibaba.nacos.api.lock.remote.request.LockOperationRequest;
import com.alibaba.nacos.api.lock.remote.response.LockOperationResponse;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.api.remote.response.ResponseCode;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.lock.remote.AbstractLockClient;
import com.alibaba.nacos.client.security.SecurityProxy;
import com.alibaba.nacos.client.utils.AppNameUtils;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.client.RpcClient;
import com.alibaba.nacos.common.remote.client.RpcClientFactory;
import com.alibaba.nacos.common.remote.client.RpcClientTlsConfigFactory;
import com.alibaba.nacos.common.remote.client.ServerListFactory;
import java.util.HashMap;
import java.util.UUID;

public class LockGrpcClient
extends AbstractLockClient {
    private final String uuid = UUID.randomUUID().toString();
    private final Long requestTimeout;
    private final RpcClient rpcClient;

    public LockGrpcClient(NacosClientProperties properties, ServerListFactory serverListFactory, SecurityProxy securityProxy) throws NacosException {
        super(securityProxy);
        this.requestTimeout = Long.parseLong(properties.getProperty("lockRequestTimeout", "-1"));
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("source", "sdk");
        labels.put("module", "lock");
        labels.put("AppName", AppNameUtils.getAppName());
        this.rpcClient = RpcClientFactory.createClient(this.uuid, ConnectionType.GRPC, labels, RpcClientTlsConfigFactory.getInstance().createSdkConfig(properties.asProperties()));
        this.start(serverListFactory);
    }

    private void start(ServerListFactory serverListFactory) throws NacosException {
        this.rpcClient.serverListFactory(serverListFactory);
        this.rpcClient.start();
    }

    @Override
    public Boolean lock(LockInstance instance) throws NacosException {
        if (!this.isAbilitySupportedByServer()) {
            throw new NacosRuntimeException(501, "Request Nacos server version is too low, not support lock feature.");
        }
        LockOperationRequest request = new LockOperationRequest();
        request.setLockInstance(instance);
        request.setLockOperationEnum(LockOperationEnum.ACQUIRE);
        LockOperationResponse acquireLockResponse = this.requestToServer(request, LockOperationResponse.class);
        return (Boolean)acquireLockResponse.getResult();
    }

    @Override
    public Boolean unLock(LockInstance instance) throws NacosException {
        if (!this.isAbilitySupportedByServer()) {
            throw new NacosRuntimeException(501, "Request Nacos server version is too low, not support lock feature.");
        }
        LockOperationRequest request = new LockOperationRequest();
        request.setLockInstance(instance);
        request.setLockOperationEnum(LockOperationEnum.RELEASE);
        LockOperationResponse acquireLockResponse = this.requestToServer(request, LockOperationResponse.class);
        return (Boolean)acquireLockResponse.getResult();
    }

    @Override
    public void shutdown() throws NacosException {
        this.rpcClient.shutdown();
    }

    private <T extends Response> T requestToServer(AbstractLockRequest request, Class<T> responseClass) throws NacosException {
        try {
            Response response;
            request.putAllHeader(this.getSecurityHeaders());
            Response response2 = response = this.requestTimeout < 0L ? this.rpcClient.request(request) : this.rpcClient.request(request, this.requestTimeout);
            if (ResponseCode.SUCCESS.getCode() != response.getResultCode()) {
                throw new NacosException(response.getErrorCode(), response.getMessage());
            }
            if (responseClass.isAssignableFrom(response.getClass())) {
                return (T)response;
            }
        }
        catch (NacosException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NacosException(500, "Request nacos server failed: ", e);
        }
        throw new NacosException(500, "Server return invalid response");
    }

    private boolean isAbilitySupportedByServer() {
        return this.rpcClient.getConnectionAbility(AbilityKey.SERVER_DISTRIBUTED_LOCK) == AbilityStatus.SUPPORTED;
    }
}

