/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.ai.remote.redo;

import com.alibaba.nacos.api.ai.model.a2a.AgentEndpoint;
import com.alibaba.nacos.client.ai.remote.AiGrpcClient;
import com.alibaba.nacos.client.ai.remote.redo.AgentEndpointRedoData;
import com.alibaba.nacos.client.ai.remote.redo.AiRedoScheduledTask;
import com.alibaba.nacos.client.ai.remote.redo.McpServerEndpoint;
import com.alibaba.nacos.client.ai.remote.redo.McpServerEndpointRedoData;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.redo.data.RedoData;
import com.alibaba.nacos.client.redo.service.AbstractRedoService;
import com.alibaba.nacos.client.redo.service.AbstractRedoTask;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiGrpcRedoService
extends AbstractRedoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiGrpcRedoService.class);
    private final AiGrpcClient aiGrpcClient;

    public AiGrpcRedoService(NacosClientProperties properties, AiGrpcClient aiGrpcClient) {
        super(LOGGER, properties, "ai");
        this.aiGrpcClient = aiGrpcClient;
        this.startRedoTask();
    }

    @Override
    protected AbstractRedoTask buildRedoTask() {
        return new AiRedoScheduledTask(this, this.aiGrpcClient);
    }

    public void cachedMcpServerEndpointForRedo(String mcpName, String address, int port, String version) {
        RedoData<McpServerEndpoint> redoData = this.buildMcpServerEndpointRedoData(mcpName, address, port, version);
        super.cachedRedoData(mcpName, redoData, McpServerEndpoint.class);
    }

    public void removeMcpServerEndpointForRedo(String mcpName) {
        super.removeRedoData(mcpName, McpServerEndpoint.class);
    }

    public void mcpServerEndpointRegistered(String mcpName) {
        super.dataRegistered(mcpName, McpServerEndpoint.class);
    }

    public void mcpServerEndpointDeregister(String mcpName) {
        super.dataDeregister(mcpName, McpServerEndpoint.class);
    }

    public void mcpServerEndpointDeregistered(String mcpName) {
        super.dataDeregistered(mcpName, McpServerEndpoint.class);
    }

    public boolean isMcpServerEndpointRegistered(String mcpName) {
        return super.isDataRegistered(mcpName, McpServerEndpoint.class);
    }

    public Set<RedoData<McpServerEndpoint>> findMcpServerEndpointRedoData() {
        return super.findRedoData(McpServerEndpoint.class);
    }

    public McpServerEndpoint getMcpServerEndpoint(String mcpName) {
        RedoData redoData = super.getRedoData(mcpName, McpServerEndpoint.class);
        return redoData == null ? null : (McpServerEndpoint)redoData.get();
    }

    private RedoData<McpServerEndpoint> buildMcpServerEndpointRedoData(String mcpName, String address, int port, String version) {
        McpServerEndpoint mcpServerEndpoint = new McpServerEndpoint(address, port, version);
        McpServerEndpointRedoData result = new McpServerEndpointRedoData(mcpName);
        result.set(mcpServerEndpoint);
        return result;
    }

    public void cachedAgentEndpointForRedo(String agentName, AgentEndpoint agentEndpoint) {
        AgentEndpointRedoData redoData = new AgentEndpointRedoData(agentName, agentEndpoint);
        super.cachedRedoData(agentName, redoData, AgentEndpoint.class);
    }

    public void removeAgentEndpointForRedo(String agentName) {
        super.removeRedoData(agentName, AgentEndpoint.class);
    }

    public void agentEndpointRegistered(String agentName) {
        super.dataRegistered(agentName, AgentEndpoint.class);
    }

    public void agentEndpointDeregister(String agentName) {
        super.dataDeregister(agentName, AgentEndpoint.class);
    }

    public void agentEndpointDeregistered(String agentName) {
        super.dataDeregistered(agentName, AgentEndpoint.class);
    }

    public boolean isAgentEndpointRegistered(String agentName) {
        return super.isDataRegistered(agentName, AgentEndpoint.class);
    }

    public Set<RedoData<AgentEndpoint>> findAgentEndpointRedoData() {
        return super.findRedoData(AgentEndpoint.class);
    }

    public AgentEndpoint getAgentEndpoint(String agentName) {
        RedoData redoData = super.getRedoData(agentName, AgentEndpoint.class);
        return redoData == null ? null : (AgentEndpoint)redoData.get();
    }
}

