/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import java.util.regex.Pattern;

public class InetAddressValidator {
    private static final String PERCENT = "%";
    private static final String DOUBLE_COLON = "::";
    private static final String DOUBLE_COLON_FFFF = "::ffff:";
    private static final String FE80 = "fe80:";
    private static final int ZERO = 0;
    private static final int SEVEN = 7;
    private static final int FIVE = 5;
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
    private static final Pattern IPV6_MIXED_COMPRESSED_REGEX = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}:(?:[0-9A-Fa-f]{1,4}:)*)?)$");
    private static final Pattern IPV6_MIXED_UNCOMPRESSED_REGEX = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){6}$");

    private InetAddressValidator() {
    }

    public static boolean isIPv4Address(String input) {
        return IPV4_PATTERN.matcher(input).matches();
    }

    public static boolean isIPv6StdAddress(String input) {
        return IPV6_STD_PATTERN.matcher(input).matches();
    }

    public static boolean isIPv6HexCompressedAddress(String input) {
        return IPV6_HEX_COMPRESSED_PATTERN.matcher(input).matches();
    }

    public static boolean isIPv6Address(String input) {
        return InetAddressValidator.isIPv6StdAddress(input) || InetAddressValidator.isIPv6HexCompressedAddress(input) || InetAddressValidator.isLinkLocalIPv6WithZoneIndex(input) || InetAddressValidator.isIPv6IPv4MappedAddress(input) || InetAddressValidator.isIPv6MixedAddress(input);
    }

    public static boolean isIPv6MixedAddress(String input) {
        int splitIndex = input.lastIndexOf(58);
        if (splitIndex == -1) {
            return false;
        }
        boolean ipv4PartValid = InetAddressValidator.isIPv4Address(input.substring(splitIndex + 1));
        String ipV6Part = input.substring(0, splitIndex + 1);
        if (DOUBLE_COLON.equals(ipV6Part)) {
            return ipv4PartValid;
        }
        boolean ipV6UncompressedDetected = IPV6_MIXED_UNCOMPRESSED_REGEX.matcher(ipV6Part).matches();
        boolean ipV6CompressedDetected = IPV6_MIXED_COMPRESSED_REGEX.matcher(ipV6Part).matches();
        return ipv4PartValid && (ipV6UncompressedDetected || ipV6CompressedDetected);
    }

    public static boolean isIPv6IPv4MappedAddress(String input) {
        if (input.length() > 7 && input.substring(0, 7).equalsIgnoreCase(DOUBLE_COLON_FFFF)) {
            String lowerPart = input.substring(7);
            return InetAddressValidator.isIPv4Address(lowerPart);
        }
        return false;
    }

    public static boolean isLinkLocalIPv6WithZoneIndex(String input) {
        int lastIndex;
        if (input.length() > 5 && input.substring(0, 5).equalsIgnoreCase(FE80) && (lastIndex = input.lastIndexOf(PERCENT)) > 0 && lastIndex < input.length() - 1) {
            String ipPart = input.substring(0, lastIndex);
            return InetAddressValidator.isIPv6StdAddress(ipPart) || InetAddressValidator.isIPv6HexCompressedAddress(ipPart);
        }
        return false;
    }
}

