/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client.grpc;

import com.alibaba.nacos.api.exception.runtime.NacosDeserializationException;
import com.alibaba.nacos.api.exception.runtime.NacosSerializationException;
import com.alibaba.nacos.api.grpc.auto.Metadata;
import com.alibaba.nacos.api.grpc.auto.Payload;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.api.utils.NetUtils;
import com.alibaba.nacos.common.remote.PayloadRegistry;
import com.alibaba.nacos.common.remote.exception.RemoteException;
import com.alibaba.nacos.shaded.com.google.protobuf.Any;
import com.alibaba.nacos.shaded.com.google.protobuf.ByteString;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class GrpcUtils {
    static ObjectMapper mapper = new ObjectMapper();

    private static String toJson(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new NacosSerializationException(obj.getClass(), (Throwable)e);
        }
    }

    public static <T> T toObj(String json, Class<T> cls) {
        try {
            return (T)mapper.readValue(json, cls);
        }
        catch (IOException e) {
            throw new NacosDeserializationException(cls, (Throwable)e);
        }
    }

    public static Payload convert(Request request, RequestMeta meta) {
        Payload.Builder payloadBuilder = Payload.newBuilder();
        Metadata.Builder metaBuilder = Metadata.newBuilder();
        if (meta != null) {
            metaBuilder.putAllHeaders(request.getHeaders()).setType(request.getClass().getSimpleName());
        }
        metaBuilder.setClientIp(NetUtils.localIP());
        payloadBuilder.setMetadata(metaBuilder.build());
        request.clearHeaders();
        String jsonString = GrpcUtils.toJson(request);
        return payloadBuilder.setBody(Any.newBuilder().setValue(ByteString.copyFrom(jsonString, StandardCharsets.UTF_8))).build();
    }

    public static Payload convert(Request request) {
        Metadata newMeta = Metadata.newBuilder().setType(request.getClass().getSimpleName()).setClientIp(NetUtils.localIP()).putAllHeaders(request.getHeaders()).build();
        request.clearHeaders();
        String jsonString = GrpcUtils.toJson(request);
        Payload.Builder builder = Payload.newBuilder();
        return builder.setBody(Any.newBuilder().setValue(ByteString.copyFrom(jsonString, StandardCharsets.UTF_8))).setMetadata(newMeta).build();
    }

    public static Payload convert(Response response) {
        String jsonString = GrpcUtils.toJson(response);
        Metadata.Builder metaBuilder = Metadata.newBuilder().setType(response.getClass().getSimpleName());
        return Payload.newBuilder().setBody(Any.newBuilder().setValue(ByteString.copyFrom(jsonString, StandardCharsets.UTF_8))).setMetadata(metaBuilder.build()).build();
    }

    public static Object parse(Payload payload) {
        Class<?> classType = PayloadRegistry.getClassByType(payload.getMetadata().getType());
        if (classType != null) {
            Object obj = GrpcUtils.toObj(payload.getBody().getValue().toString(StandardCharsets.UTF_8), classType);
            if (obj instanceof Request) {
                ((Request)obj).putAllHeader(payload.getMetadata().getHeadersMap());
            }
            return obj;
        }
        throw new RemoteException(500, "Unknown payload type:" + payload.getMetadata().getType());
    }

    static {
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static class PlainRequest {
        String type;
        Object body;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Object getBody() {
            return this.body;
        }

        public void setBody(Object body) {
            this.body = body;
        }
    }
}

